#include "deviceinfo.h"
#include <QSystemInfo>
#include <QSystemDeviceInfo>
#include <QCoreApplication>
#include <QDebug>

QTM_USE_NAMESPACE

DeviceInfo::DeviceInfo(QObject *parent) :
    QObject(parent) {

    QSystemDeviceInfo deviceInfo;
    m_uuid = deviceInfo.imei();
    m_name = QString("%2 %3 (%1)").arg(deviceInfo.productName(), deviceInfo.manufacturer(), deviceInfo.model());

#if defined(Q_OS_SYMBIAN)
    QSysInfo sysInfo;
    m_platform = "Symbian";
    switch (sysInfo.symbianVersion()) {
    case QSysInfo::SV_9_2: m_version = "v9.2"; break;
    case QSysInfo::SV_9_3: m_version = "v9.3"; break;
    case QSysInfo::SV_9_4: m_version = "v9.4"; break;
    //case QSysInfo::SV_SF_1: m_version = "^1"; break; // same as v9.4
    case QSysInfo::SV_SF_2: m_version = "^2"; break;
    case QSysInfo::SV_SF_3: m_version = "^3"; break;
    case QSysInfo::SV_SF_4: m_version = "^4"; break;
    default: m_version = "unknown";
    }
#elif defined(Q_WS_MAEMO_5)
    m_platform = "Maemo";
    m_version = "5";
#else
    m_platform = "unknown";
    m_version = "unknown";
#endif

    qDebug() << "Name: " << m_name;
    qDebug() << "Platform: " << m_platform;
    qDebug() << "Version: " << m_version;
    qDebug() << "UUID: " << m_uuid;
    qDebug() << "PhoneGap: " << QCoreApplication::applicationVersion();
    qDebug() << "Qt: " << qVersion();
}

const QString &DeviceInfo::name() const {

    return m_name;
}

const QString &DeviceInfo::platform() const {

    return m_platform;
}

const QString &DeviceInfo::uuid() const {

    return m_uuid;
}

const QString &DeviceInfo::version() const {

    return m_version;
}

QString DeviceInfo::phonegapVersion() const {

    return QCoreApplication::applicationVersion();
}
