#include <QtCore/QtCore>
#define COMMON
#include "common.h"
#ifdef Q_WS_MAEMO_5
#include <alarmd/libalarm.h>
#include <time.h>
#endif

QList<Channel> channels;
QList<Task> tasks;

#if defined Q_OS_LINUX
#if defined PATH_PREFIX
QString ppref=PATH_PREFIX;
#else
QString ppref="/usr";
#endif
#endif

QString crontab=".crontab";

#if defined Q_OS_MAC
QString chanFile="../Resources/channels";
#elif defined Q_WS_MAEMO_5
QString chanFile="/opt/maemo/usr/share/hskiste/channels";
#elif defined Q_OS_LINUX
QString chanFile=ppref+"/share/hskiste/channels";
#else
QString chanFile="channels";
#endif


QString taskFile="tasks";
QString mplayer="mplayer";
QString lame="lame";
QString oggenc="oggenc";
QString stdDir=".";
QString finalCmd="";

#if defined Q_OS_WIN32
	bool useSchtasks = true;
	bool monthBeforeDay = false;
	QString once = "einmal";
#define SCHTASKSFILE "./cur_schtasks"
#endif


#if defined Q_WS_MAEMO_5
	QString configFile = QDir::homePath() + "/.hskiste.conf";
#elif defined Q_OS_MAC
	QString configFile = QDir::homePath() + "/Library/Preferences/hskiste.conf";
#elif defined Q_OS_WIN32
	QString configFile = "hskiste.conf";
#elif defined Q_OS_LINUX
	QString configFile = QDir::homePath() + "/.hskiste.conf";
#else
	QString configFile = QDir::homePath() + "/.hskiste.conf";
#endif



QTextStream errorS(stderr,QIODevice::WriteOnly);
QTextStream outS(stdout,QIODevice::WriteOnly);
QTextStream inS(stdin,QIODevice::ReadOnly);
QTextStream logS;


QDateTime Task::pstart(){
	return start;
}
QDateTime Task::pstop(){
	return stop;
}
QString Task::pauthor(){
	return author;
}
QString Task::ptitle(){
	return title;
}
QString Task::pchanMnemo(){
	return chanMnemo;
}
bool Task::precord(){
	return status;
}

void Task::setStart(const QDateTime val){
	start = val;
}
void Task::setStop(const QDateTime val){
	stop = val;
}
void Task::setAuthor(const QString val){
	author = val;
}
void Task::setTitle(const QString val){
	title = val;
}
void Task::setChanMnemo(const QString  val){
	chanMnemo = val;
}
void Task::setRecord(bool  val){
	if(val == ((bool) status))
		return;
	status = val ? 1 : 0;
	emit recordChanged();
}

Task::Task(){
		jobNumber=0;
		file="";
		ft=-1;
		author="";
		title=tr("NEUER TERMIN");
		chanMnemo="";
		chanType=0;
		status=TODO;
		doFinalCmd=true;
		unsaved=true;
		start=QDateTime::currentDateTime();
		stop=QDateTime::currentDateTime();
}

Task::Task(const Task& tk) :  QObject(){
		jobNumber=tk.jobNumber;
		start = tk.start;
		stop = tk.stop;
		file= tk.file;
		ft= tk.ft;
		author = tk.author;
		title = tk.title;
		chanMnemo = tk.chanMnemo;
		chanType = tk.chanType;
		status = tk.status;
		doFinalCmd =  tk.doFinalCmd;
		unsaved = tk.unsaved;
}

Task Task::operator=(const Task& tk){
	jobNumber=tk.jobNumber;
	start = tk.start;
	stop = tk.stop;
	file= tk.file;
	ft= tk.ft;
	author = tk.author;
	title = tk.title;
	chanMnemo = tk.chanMnemo;
	chanType = tk.chanType;
	status = tk.status;
	doFinalCmd =  tk.doFinalCmd;
	unsaved = tk.unsaved;
	return *this;
}


void initLog(){
	#if defined (Q_WS_MAEMO_5) || defined (Q_OS_LINUX) || defined (Q_OS_MAC)
	QFile *log = new QFile("/tmp/hs.log");
	// #elif defined Q_OS_WIN32
	// QFile *log = new QFile(QDir::homePath() + "\\hs.log");
	#else
	QFile *log = new QFile("hs.log");
	#endif
	log->open(QIODevice::Append|QIODevice::Text);
	logS.setDevice(log);
	logS << "==== " << QDateTime::currentDateTime().toString(Qt::ISODate) << " ===" << endl;
}


Task* getTaskByJobNumber(int jobn){
	for(int i=0; i<tasks.count();i++){
		if(tasks[i].jobNumber == jobn)
			return &(tasks[i]);
	}
	return NULL;
}

Channel* getChannelByMnemoType(QString mnemo, int type){
	for(int i=0; i<channels.count();i++){
		if(channels[i].mnemo == mnemo && channels[i].type == type)
			return &(channels[i]);
	}
	return NULL;
}

void readChannels(){
	QFile *chFile = new QFile(chanFile);
	chFile->open(QIODevice::ReadOnly|QIODevice::Text);
	QTextStream *chanStr = new QTextStream(chFile);
	
	QString ipline("");
	while (!(ipline = chanStr->readLine()).isNull()){
		QStringList sl =  ipline.split(";:;");
		if(sl.count() != 4)
			continue;
		Channel *ch = new Channel;
		ch->name = sl[0];
		ch->mnemo = sl[1];
		ch->address = sl[2];
		ch->type = sl[3].toInt();
		channels.append(*ch);
	}
	chFile->close();
}

QList<Task> readTasks(QString taskFile){
	QList<Task> tasks;
	QFile *tkFile = new QFile(taskFile);
	tkFile->open(QIODevice::ReadOnly|QIODevice::Text);
	QTextStream *tkStr = new QTextStream(tkFile);
	
	QString ipline("");
	while (!(ipline = tkStr->readLine()).isNull()){
		QStringList sl =  ipline.split(SEP);
		if(sl.count() != 20)
			continue;
		Task *tk = new Task;
		tk->jobNumber = sl[0].toInt();
		tk->start = QDateTime( *new QDate ( sl[1].toInt(), sl[2].toInt(), sl[3].toInt()), 
				 *new QTime(sl[4].toInt(),sl[5].toInt()));
		tk->stop = QDateTime( *new QDate ( sl[6].toInt(), sl[7].toInt(), sl[8].toInt()), 
				 *new QTime(sl[9].toInt(),sl[10].toInt()));
		tk->file = sl[11];
		tk->ft = sl[12].toInt();
		tk->fq = sl[13].toInt();
		tk->author = sl[14];
		tk->title = sl[15];
		tk->chanMnemo = sl[16];
		tk->chanType = sl[17].toInt();
		tk->status = sl[18].toInt();
		tk->doFinalCmd = (bool) sl[19].toInt();
		tk->unsaved=false;
		tasks.append(*tk);
	}
	tkFile->close();
	return tasks;
}
void  readTasks(){
	tasks = readTasks(taskFile);
}

void writeTasks(QString taskFile, QList<Task> tasks){
	QFile *tkFile = new QFile(taskFile);
	tkFile->open(QIODevice::WriteOnly|QIODevice::Text);
	QTextStream *tkStr = new QTextStream(tkFile);
	
	QString opline("");
	for(int i =0;i< tasks.count();i++){
		Task tk = tasks[i];
		opline = QString::number(tk.jobNumber) + SEP;
		opline += tk.start.toString("yyyy") + SEP;
		opline += tk.start.toString("M") + SEP;
		opline += tk.start.toString("d") + SEP;
		opline += tk.start.toString("h") + SEP;
		opline += tk.start.toString("m") + SEP;
		opline += tk.stop.toString("yyyy") + SEP;
		opline += tk.stop.toString("M") + SEP;
		opline += tk.stop.toString("d") + SEP;
		opline += tk.stop.toString("h") + SEP;
		opline += tk.stop.toString("m") + SEP;
		opline += tk.file + SEP;
		opline += QString::number(tk.ft) + SEP;
		opline += QString::number(tk.fq) + SEP;
		opline += tk.author + SEP;
		opline += tk.title + SEP;
		opline += tk.chanMnemo + SEP;
		opline += QString::number(tk.chanType) + SEP;
		opline += QString::number(tk.status) + SEP;
		opline += QString::number((int)tk.doFinalCmd);
		*tkStr << opline << endl;

	}
	
	tkStr->flush();
	tkFile->close();
}
void writeTasks(){
	writeTasks(taskFile, tasks);
}

void tasksToCrontab(){
	QString exec = "hstarter";
	#ifdef Q_OS_WIN32
		exec += ".exe";
	#endif
	#if defined Q_OS_LINUX
		QString command = ppref+"/bin/hstarter";
	#elif defined (Q_OS_MAC) 
		QString command = "\""+QDir::current().absolutePath() + "/" + exec + "\"";
	#else
		QString command = "./" + exec;
	#if defined (Q_OS_WIN32)
	if(!useSchtasks)//Windows with cron
		command = "\""+QDir::current().absolutePath() + "/" + exec + "\"";
	#endif
	#endif
	
	#if defined Q_WS_MAEMO_5
// 	alarm_event_t *aev = alarm_event_create();
// 	time_t ti = 1281677890;
// 	struct tm* tmp =  gmtime(&ti);
// 	aev->alarm_time = (time_t) time(NULL) + 60;
// 	alarm_event_set_alarm_appid(aev,"muhahaha");
// 	alarm_action_t* aa =  alarm_event_add_actions(aev,1);
// 	alarm_action_set_exec_command(aa,"/usr/bin/pygtkeditor");
// 	aa->flags = ALARM_ACTION_WHEN_TRIGGERED | ALARM_ACTION_TYPE_EXEC;
// 	cookie_t ck= alarmd_event_add (aev);
// 	errorS << ck << " " << endl; 
// 	return;
	QList<long> oldCookies;
	QFile crtab(crontab/*TODO: rename*/);
	crtab.open(QIODevice::ReadOnly|QIODevice::Text);
	QTextStream str(&crtab);
	QString ipline("");
	while (!(ipline = str.readLine()).isNull()){
		bool ok=true;
		long ck = ipline.toULong(&ok);
		if(ok)
			oldCookies.append(ck);
	}
	crtab.close();
	
	for (int i = 0; i < oldCookies.size(); ++i)
		alarmd_event_del(oldCookies.at(i));
	
	QString newCookies = "";
	
	#else
	QString before,hspart,after,ipline;
	QFile crtab;
	QTextStream str;
	
	#if defined Q_OS_WIN32
	QString newCookies = "";
	if(useSchtasks){

	QStringList oldCookies;
	crtab.setFileName(SCHTASKSFILE);
	crtab.open(QIODevice::ReadOnly|QIODevice::Text);
	QTextStream str(&crtab);
	QString ipline("");
	while (!(ipline = str.readLine()).isNull()){
		if(ipline != "")
			oldCookies.append(ipline);
	}
	crtab.close();
	
	for (int i = 0; i < oldCookies.size(); ++i)
		QProcess::execute("schtasks /Delete /F /TN " + oldCookies.at(i));
		

	
	} else {
	#endif
	
	before = "";
	after = "";
	hspart = HSBEGIN + QString("\n");
	crtab.setFileName(crontab);
	crtab.open(QIODevice::ReadOnly|QIODevice::Text);
	str.setDevice(&crtab);
	ipline ="";
	while (!(ipline = str.readLine()).isNull() && ipline != HSBEGIN)
		before += ipline + "\n";
	while (!(ipline = str.readLine()).isNull() && ipline != HSEND) ;
	while (!(ipline = str.readLine()).isNull())
		after += ipline + "\n";
	crtab.close();
	
	#if defined Q_OS_WIN32
	}
	#endif
	
	#endif

	
	
	
	
	for(int i =0; i< tasks.count(); i++){
		Task& tk= tasks[i];
		if(!tk.status)
			continue;
		
		
		#if defined Q_WS_MAEMO_5
		alarm_event_t *start_aev = alarm_event_create();
		alarm_event_t *stop_aev = alarm_event_create();

		
		start_aev->alarm_time = (time_t) tk.start.toTime_t();
		stop_aev->alarm_time = (time_t) tk.stop.toTime_t();
		
		alarm_event_set_alarm_appid(start_aev,tk.title.toUtf8().data());
		alarm_event_set_alarm_appid(stop_aev,tk.title.toUtf8().data());
		
		alarm_action_t* start_aa =  alarm_event_add_actions(start_aev,1);
		alarm_action_t* stop_aa =  alarm_event_add_actions(stop_aev,1);
		
		alarm_action_set_exec_command(start_aa,(command + " -start " + QString::number(tk.jobNumber)).toUtf8().data());
		alarm_action_set_exec_command(stop_aa,(command + " -stop " + QString::number(tk.jobNumber)).toUtf8().data());
		
		start_aa->flags = stop_aa->flags =  ALARM_ACTION_WHEN_TRIGGERED | ALARM_ACTION_TYPE_EXEC;
		
		long start_ck= alarmd_event_add(start_aev);
		long stop_ck= alarmd_event_add(stop_aev);
		
		
		newCookies += QString::number(start_ck) + "\n" + QString::number(stop_ck) + "\n";
		
		#else
		#if defined Q_OS_WIN32
		if(useSchtasks){
		//the creation time of the task will help to identify it
		QDateTime now = QDateTime::currentDateTime();


		QString startTN = "hskStart_" + now.time().toString("hhmmss") + "_" + QString::number(tk.jobNumber);
		QString stopTN = "hskStop_" + now.time().toString("hhmmss") + "_" + QString::number(tk.jobNumber);

		QString startDate = monthBeforeDay ? tk.start.date().toString("MM/dd/yyyy") : tk.start.date().toString("dd/MM/yyyy");
		QString stopDate = monthBeforeDay ? tk.stop.date().toString("MM/dd/yyyy") : tk.stop.date().toString("dd/MM/yyyy");
		
		QString startTime = tk.start.time().toString("hh:mm:ss");
		QString stopTime = tk.stop.time().toString("hh:mm:ss");
		
/*		version with explicit path to hskiste (did not work)
		QProcess::execute("C:/windows/system32/schtasks.exe /Create /RU SYSTEM /TN " + startTN +  
			" /TR \"" + command + " -start " + QString::number(tk.jobNumber) + "\" /SC " + 
			once + " /SD " + startDate+ " /ST " + startTime);
*/
		QProcess::execute("C:/windows/system32/schtasks.exe /Create /RU SYSTEM /TN " + startTN +  
			" /TR \"" + command + " -start " + QString::number(tk.jobNumber) + "\" /SC " + 
			once + " /SD " + startDate+ " /ST " + startTime);
		
		logS << "run: " << ("C:/windows/system32/schtasks.exe /Create /RU SYSTEM /TN " + stopTN +  
			" /TR \"" + command + " -stop " + QString::number(tk.jobNumber) + "\" /SC " + 
			once + " /SD " + stopDate+ " /ST " + stopTime) << endl;
			
		logS << "exit code: " << QProcess::execute("C:/windows/system32/schtasks.exe /Create /RU SYSTEM /TN " + stopTN +  
			" /TR \"" + command + " -stop " + QString::number(tk.jobNumber) + "\" /SC " + 
			once + " /SD " + stopDate+ " /ST " + stopTime) << endl;;

		newCookies += startTN + "\n" + stopTN + "\n";
		} else {
		
		#endif
		
		hspart += tk.start.toString("m h d M ") + 
			QString::number(tk.start.date().dayOfWeek()) + " " +
			command + " -start " + QString::number(tk.jobNumber) + "\n";
		hspart += tk.stop.toString("m h d M ") +
			QString::number(tk.stop.date().dayOfWeek()) + " " +
			command + " -stop " + QString::number(tk.jobNumber) + "\n";
		#endif
		#ifdef Q_OS_WIN32
		}
		#endif
	}
	#if defined(Q_WS_MAEMO_5)
	crtab.open(QIODevice::WriteOnly|QIODevice::Text);
	str << newCookies;
	crtab.close();
	#else
	#if defined (Q_OS_WIN32)
	if(useSchtasks){//Windows with schtasks
		logS << newCookies << endl;
		logS << crtab.open(QIODevice::WriteOnly|QIODevice::Text);
		str.setDevice(&crtab);
		str << newCookies << endl;
		crtab.flush();
		crtab.close();
	} else {
	#endif
	//not Windows (compiletime) or Windows with cron (runtime)
	
	hspart += HSEND + QString("\n");
	crtab.open(QIODevice::WriteOnly|QIODevice::Text);
	str.setDevice(&crtab);
	str << before << hspart << after;
	crtab.close();
	
	//on Windows I assume pycron (if not schtasks), which has just one file, it automatically checks
	//for another service like icron, a restart may be required
	#ifdef Q_OS_UNIX
		QProcess::execute("crontab " + crontab);
	#endif
	
	#if defined (Q_OS_WIN32)
	}//final brace for runtime else case (i.e. Windows with cron )
	#endif
	
	//next endif ends the not Maemo5 case
	#endif
}

void interpret_line(QString line){
	QStringList sl = line.split(DEFSEP);
	if(sl.count() != 2)
		return;
	if(sl[0] == "mplayer")
		mplayer = sl[1];
	if(sl[0] == "crontab")
		crontab = sl[1];
	if(sl[0] == "chanFile")
		chanFile = sl[1];
	if(sl[0] == "taskFile")
		taskFile = sl[1];
	if(sl[0] == "oggenc")
		oggenc = sl[1];
	if(sl[0] == "lame")
		lame = sl[1];
	if(sl[0] == "finalCmd")
		finalCmd = sl[1];
	if(sl[0] == "stdDir")
		stdDir = sl[1];
#ifdef Q_OS_WIN32
	if(sl[0] == "useSchtasks")
		useSchtasks = (sl[1] == "true");
	if(sl[0] == "monthBeforeDay")
		monthBeforeDay = (sl[1] == "true");
	if(sl[0] == "once")
		once = sl[1];
#endif
}

void writeConfig(){
	QFile *conf = new QFile(configFile);
// 	if(!(new QFileInfo(configFile)->absoluteDir()).exists())
// 		return;
	conf->open(QIODevice::WriteOnly|QIODevice::Text);
	QTextStream confStr(conf);
	confStr << "mplayer" << DEFSEP << mplayer << endl;
	confStr << "crontab" << DEFSEP << crontab << endl;
	confStr << "chanFile" << DEFSEP << chanFile << endl;
	confStr << "taskFile" << DEFSEP << taskFile << endl;
	confStr << "lame" << DEFSEP << lame << endl;
	confStr << "oggenc" << DEFSEP << oggenc << endl;
	confStr << "stdDir" << DEFSEP << stdDir << endl;
	confStr << "finalCmd" << DEFSEP << finalCmd << endl;
#ifdef Q_OS_WIN32
	confStr << "monthBeforeDay" << DEFSEP << (monthBeforeDay ? "true" : "false")<< endl;
	confStr << "useSchtasks" << DEFSEP << (useSchtasks ? "true" : "false")<< endl;
	confStr << "once" << DEFSEP << once << endl;
#endif
	conf->close();
}


void readConfig(){
	QFile *conf = new QFile(configFile);
	if(!conf->exists())
		return;
	conf->open(QIODevice::ReadOnly|QIODevice::Text);
	QTextStream *confStr = new QTextStream(conf);
	
	QString ipline("");
	while (!(ipline = confStr->readLine()).isNull())
		interpret_line(ipline);
	conf->close();
}

QString typeToString(int type){
	switch(type){
	case FMT_MP3:
		return QString("mp3");
	case FMT_OGG:
		return QString("ogg");
	case FMT_WAV:
		return QString("wave");
	case FMT_REAL:
		return QString("real");
	case FMT_WMA:
		return QString("wma");
	}
	return "";
}
