#!/bin/sh

# Part of h-e-n, this is not The Right Way(TM) to handle file system mounting.
# ke-recv always runs on Maemo 5 as a daemon, yet it does not properly handle
# mounting.
# Help would be appreciated with ke-recv.

# Thanks to debernardis for help with the script.

mountpartitions() {
list=`awk '$4~"[0-9]$"{print $4}' /proc/partitions | grep -v "mmcblk*" | grep -v "loop*"`
for partitions in $list
	do
		mkdir -p /media/$partitions
		mount -o rw,noauto,nodev,noexec,nosuid,noatime,nodiratime,utf8,uid=29999,shortname=mixed,dmask=000,fmask=0133,rodir /dev/$partitions /media/$partitions
done
}

unmount() {
lista=`awk '$4~"[0-9]$"{print $4}' /proc/partitions | grep -v "mmcblk*" | grep -v "loop*"`
for partitions in $lista
	do
		umount /media/$partitions
		# Don't clutter up /media, remove mount points one by one
		rmdir /media/$partitions
done
}    

if [ "$1" = "--mount" ]
	then
		mountpartitions
fi

if [ "$1" = "--unmount" ]
	then
		unmount
fi
