#include "horizontalcall.h"
#include "appsettingsmanager.h"
#include "ui_horizontalcall.h"
#include <QtMaemo5>
#include <QtDBus>
#include <QtDBus/QtDBus>

using namespace QtMobility;

horizontalcall::horizontalcall(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::horizontalcall)
{
    m_Landscape = true;
    m_FetchPending = false;
    m_DisplayingContact = false;
    createStyle();
    ui->setupUi(this);
    m_VisibleItem = 0;
    m_LastVisibleItemRow = 0;
    m_CurrentRow = 0;
    m_FetchRequest = new QContactFetchRequest();
    numberOfLettersPerRow = 6;
    m_Contacts = QList<QContact>();
    m_NameStrings = QList<QStringList>();
    existingLetterButtons = new QList<QPushButton*>();
    existingLetters = new QList<QString>();
    m_CurrentFilter = QString();
    m_DisplayedPhoneNumbersButtons = QList<QPushButton*>();

    createSharedUI();

    getRotationSettings();
    if (m_AutorotationEnabled)
    {
        qDebug() << "Main Thread : Init : Autorotation is set to automatic";
        rotator = new QtMaemo5Rotator(QtMaemo5Rotator::AutomaticBehavior, this);
    }
    else
    {
        if (m_Landscape) {
            qDebug() << "Main Thread : I am in landscape mode";
            rotator = new QtMaemo5Rotator(QtMaemo5Rotator::LandscapeBehavior, this);
        } else {
            qDebug() << "Main Thread : I am in portrait mode";
            rotator = new QtMaemo5Rotator(QtMaemo5Rotator::PortraitBehavior, this);
        }
    }

    if (m_AutorotationEnabled) {
        if (width() > height()) {
            qDebug() << "Main Thread : Creating landscape UI";
            createLandscapeUI();
            m_Landscape = true;
        } else {
            qDebug() << "Main Thread : Creating portrait UI";
            createPortraitUI();
            m_Landscape = false;
        }
    } else {
        if (m_Landscape) {
            qDebug() << "Main Thread : Going to Create landscape UI";
            createLandscapeUI();
        } else {
            qDebug() << "Main Thread : Going to Create portrait UI";
            createPortraitUI();
        }
    }

    m_scrollArea = NULL;
    m_FetchPending = true;

    QTimer::singleShot(1000, this, SLOT(fetchContacts()));
}

void horizontalcall::fetchContacts()
{
    lineEditFilter->setText("Loading...");
    emit getContacts();
}

void horizontalcall::ContactUpdatesDone()
{
    qDebug() << "Main Thread : Done updateing contacts.";
    lineEditFilter->setText("");
    m_FetchPending = false;
    lineEditTextChanged(lineEditFilter->text());
}

void horizontalcall::getRotationSettings()
{
    QSettings settings;
    m_AutorotationEnabled = settings.value("AutoRotation", true).value<bool>();
    qDebug() << "Main Thread : AutoRotation : " << m_AutorotationEnabled;
    m_Landscape = settings.value("ManualRotationLandscape", true).value<bool>();
    qDebug() << "Main Thread : ManualRotation : " << m_Landscape;
}

void horizontalcall::doAction1()
{
    QSettings settings;
    //Autorotation
    if (m_AutorotationEnabled) {
        QMaemo5InformationBox::information(this, "AutoRotation is now <b>Disabled</b>", QMaemo5InformationBox::DefaultTimeout);
        m_AutorotationEnabled = false;
        settings.setValue("AutoRotation", false);
        if (m_Landscape) {
            rotator->setCurrentBehavior(QtMaemo5Rotator::LandscapeBehavior);
        } else {
            rotator->setCurrentBehavior(QtMaemo5Rotator::PortraitBehavior);
        }
    } else {
        QMaemo5InformationBox::information(this, "AutoRotation is now <b>Enabled</b>", QMaemo5InformationBox::DefaultTimeout);
        m_AutorotationEnabled = true;
        settings.setValue("AutoRotation", true);
        rotator->setCurrentBehavior(QtMaemo5Rotator::AutomaticBehavior);
    }
}

void horizontalcall::doAction2()
{
    QSettings settings;
    //Manualrotation
    if (m_AutorotationEnabled) {
        m_AutorotationEnabled = false;
        settings.setValue("AutoRotation", false);
        rotator->setCurrentBehavior(QtMaemo5Rotator::AutomaticBehavior);
    }
    if (m_Landscape) {
        qDebug() << "Main Thread : Switching from landscape to portrait, manual.";
        settings.setValue("ManualRotationLandscape", false);
        QMaemo5InformationBox::information(this, "Perspective is now : <b>Portrait</b>", QMaemo5InformationBox::DefaultTimeout);
        rotator->setCurrentBehavior(QtMaemo5Rotator::PortraitBehavior);
    } else {
        qDebug() << "Main Thread : Switching from portrait to landscape, manual.";
        settings.setValue("ManualRotationLandscape", true);
        QMaemo5InformationBox::information(this, "Perspective is now : <b>Landscape</b>", QMaemo5InformationBox::DefaultTimeout);
        rotator->setCurrentBehavior(QtMaemo5Rotator::LandscapeBehavior);
    }
}

void horizontalcall::doAction3()
{
    listWidgetFiltered->clear();
    m_NameStrings.clear();
    deleteLetters();
    fetchContacts();
}

void horizontalcall::createSharedUI()
{
    //Set mainLayout.
    this->setWindowTitle("Horizontal-Call");

    //Create menu
    action1 = new QAction(tr("&AutoRotation"), this);
    action2 = new QAction(tr("&ManualRotation"), this);
    action3 = new QAction(tr("&Refresh Contacts"), this);

    menu = menuBar()->addMenu(tr("Menu"));
    menu->addAction(action1);
    menu->addAction(action2);
    menu->addAction(action3);

    connect(action1, SIGNAL(triggered()), this , SLOT(doAction1()));
    connect(action2, SIGNAL(triggered()), this , SLOT(doAction2()));
    connect(action3, SIGNAL(triggered()), this , SLOT(doAction3()));

    //List Widget Filtered
    listWidgetFiltered = new QListWidget(centralWidget());
    connect(listWidgetFiltered, SIGNAL(clicked(QModelIndex)), this, SLOT(itemClicked(QModelIndex)));
    listWidgetFiltered->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    listWidgetFiltered->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    listWidgetFiltered->setStyleSheet(m_StyleQListWidget);

    //Minimize Button
    pushButtonMinimize = new QPushButton(centralWidget());
    connect(pushButtonMinimize, SIGNAL(clicked()), this, SLOT(minimizeButtonClicked()));
    pushButtonMinimize->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    pushButtonMinimize->setText("Toggle");

    //Exit Button
    pushButtonExit     = new QPushButton(centralWidget());
    connect(pushButtonExit, SIGNAL(clicked()), this, SLOT(exitButtonClicked()));
    pushButtonExit->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    pushButtonExit->setText("Exit");

    //LineEdit
    lineEditFilter  = new QLineEdit(centralWidget());
    connect(lineEditFilter, SIGNAL(textChanged(QString)),this, SLOT(lineEditTextChanged(QString)));
    lineEditFilter->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    //Clear Button
    pushButtonClear = new QPushButton(centralWidget());
    connect(pushButtonClear, SIGNAL(clicked()), this, SLOT(clearButtonClicked()));
    pushButtonClear->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    pushButtonClear->setText("<");
    //Reset Button
    pushButtonReset = new QPushButton(centralWidget());
    connect(pushButtonReset, SIGNAL(clicked()), this, SLOT(resetButtonClicked()));
    pushButtonReset->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    pushButtonReset->setText("Reset");

    //Letters Grid
    lettersGridLayoutWidget = new QWidget(centralWidget());
    lettersGridLayout = new QGridLayout();
    lettersGridLayout->setSpacing(0);
    lettersGridLayout->setMargin(0);
    lettersGridLayoutWidget->setLayout(lettersGridLayout);
}

void horizontalcall::createPortraitUI()
{
    qDebug("Main Thread : Creating Portrait UI");
    //Create Main Layout
    mainLayoutPortrait = new QVBoxLayout();
    mainLayoutPortrait->setSpacing(0);
    mainLayoutPortrait->setMargin(0);
    centralWidget()->setLayout(mainLayoutPortrait);

    //Take care of top middle and bottom
    //Top
    topWidget = new QWidget(centralWidget());
    topWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    topWidget->setFixedHeight(70);
    mainLayoutPortrait->addWidget(topWidget);
    topLayout = new QHBoxLayout();
    topLayout->setSpacing(0);
    topLayout->setMargin(0);
    topWidget->setLayout(topLayout);

    //List Widget filtered in top right
    mainLayoutPortrait->addWidget(listWidgetFiltered);
    //Middle
    middleWidget = new QWidget(centralWidget());
    middleWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    middleWidget->setFixedHeight(70);
    mainLayoutPortrait->addWidget(middleWidget);
    middleLayout = new QHBoxLayout();
    middleLayout->setSpacing(0);
    middleLayout->setMargin(0);
    middleWidget->setLayout(middleLayout);

    //Grid
    lettersGridLayoutWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    lettersGridLayoutWidget->setFixedHeight(400);
    mainLayoutPortrait->addWidget(lettersGridLayoutWidget);
    lettersGridLayoutWidget->setLayout(lettersGridLayout);lettersGridLayoutWidget->setLayout(lettersGridLayout);


    //Minimize
    topLayout->addWidget(pushButtonMinimize);

    //Exit
    topLayout->addWidget(pushButtonExit);

    //Line Edit Filter
    middleLayout->addWidget(lineEditFilter);

    //Clear Button
    middleLayout->addWidget(pushButtonClear);

    //Reset Button
    middleLayout->addWidget(pushButtonReset);

    ui->centralWidget->show();
    init();
}

void horizontalcall::createLandscapeUI()
{
    qDebug("Main Thread : Creating Landscape UI");
    //Create Main Layout
    mainLayout = new QHBoxLayout();
    mainLayout->setSpacing(0);
    mainLayout->setMargin(0);
    centralWidget()->setLayout(mainLayout);

    //Take care of left side and right side
    leftWidget = new QWidget(centralWidget());
    leftWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    mainLayout->addWidget(leftWidget);
    leftLayout = new QVBoxLayout();
    leftLayout->setSpacing(0);
    leftLayout->setMargin(0);
    leftWidget->setLayout(leftLayout);
    rightWidget = new QWidget(centralWidget());
    rightWidget->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding);
    rightWidget->setFixedWidth(240);
    mainLayout->addWidget(rightWidget);
    rightLayout = new QVBoxLayout();
    rightLayout->setSpacing(0);
    rightLayout->setMargin(0);
    rightWidget->setLayout(rightLayout);

    //Take care of filter controls in left side
    filterControlsWidget = new QWidget(leftWidget);
    filterControlsWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    filterControlsWidget->setFixedHeight(70);
    leftLayout->addWidget(filterControlsWidget);
    filterControlsLayout = new QHBoxLayout();
    filterControlsLayout->setSpacing(0);
    filterControlsLayout->setMargin(0);
    filterControlsWidget->setLayout(filterControlsLayout);

    //Line Edit Filter
    filterControlsLayout->addWidget(lineEditFilter);

    //Clear Button
    filterControlsLayout->addWidget(pushButtonClear);

    //Reset Button
    filterControlsLayout->addWidget(pushButtonReset);

    //Take care of grid layout for letters / details
    lettersGridLayoutWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    lettersGridLayoutWidget->setMaximumHeight(1000);
    lettersGridLayoutWidget->setMinimumHeight(0);
    leftLayout->addWidget(lettersGridLayoutWidget);
    lettersGridLayoutWidget->setLayout(lettersGridLayout);

    //Take care of window controls
    windowControlsWidget = new QWidget(rightWidget);
    windowControlsWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    windowControlsWidget->setFixedHeight(70);
    rightLayout->addWidget(windowControlsWidget);
    windowControlsLayout = new QHBoxLayout();
    windowControlsLayout->setSpacing(0);
    windowControlsLayout->setMargin(0);
    windowControlsWidget->setLayout(windowControlsLayout);
    rightWidget->setLayout(windowControlsLayout);

    //Minimize Button
    windowControlsLayout->addWidget(pushButtonMinimize);

    //Exit Button
    windowControlsLayout->addWidget(pushButtonExit);

    //List Widget filtered
    rightLayout->addWidget(listWidgetFiltered);

    ui->centralWidget->show();
    init();
}

void horizontalcall::resizeEvent(QResizeEvent *e)
{
    QMainWindow::resizeEvent(e);

    QSettings settings;
    qDebug("Main Thread : Resize Event");
    //    if (m_FetchPending) {
    //        qDebug("Main Thread : Still fetching contacts, Ignoring rotation.");
    //        return;
    //    }

    qDebug() << "width=" << width() << "height=" << height();

    if (width() > height())
    {
        qDebug("Main Thread : Landscape Mode Recognized");
        if (m_Landscape)
        {
            qDebug("Main Thread : Already In Landscape Mode");
            return;
        } else {
            m_Landscape = true;
            destroyPortraitUI();
            createLandscapeUI();
            settings.setValue("ManualRotationLandscape", true);
        }
    } else {
        qDebug("Main Thread : Portratin Mode Recognized");
        if (!m_Landscape) {
            qDebug("Main Thread : Already In Portrait Mode");
            return;
        } else {
            m_Landscape = false;
            destroyLandscapeUI();
            createPortraitUI();
            settings.setValue("ManualRotationLandscape", false);
        }
    }

    if (m_DisplayingContact) {
        listWidgetFiltered->setCurrentRow(m_CurrentRow);
        lineEditFilter->setText(m_CurrentFilter);
        showContactDetails(m_CurrentRow);


    } else {
        lineEditFilter->setText(m_CurrentFilter);
        qDebug("Main Thread : Calling lineEdit Text Changed After UI Change");
        lineEditTextChanged(m_CurrentFilter);
    }
}

void horizontalcall::closeEvent(QCloseEvent *event)
{
    qDebug() << "Main Thread : Close event Called.";
    hide();
    event->ignore();
}

int horizontalcall::top_application()
{
    qDebug() << "Main Thread : Top Application Slot Called.";
    show();
    this->activateWindow();
    this->raise();
    return 0;
}

void horizontalcall::AddContact(QContact temp)
{
    qDebug() << "Main Thread : Got contact to update.";
    QContactDisplayLabel displayLabel = temp.detail(QContactDisplayLabel::DefinitionName);
    listWidgetFiltered->addItem(displayLabel.label());
    QStringList tempQStringList = displayLabel.label().split(" ", QString::SkipEmptyParts);
    tempQStringList.append(displayLabel.label());

    /*QList<QContactPhoneNumber> allDetails = temp.details<QContactPhoneNumber>();

    for (int i = 0; i < allDetails.size(); i++) {
        tempQStringList.append(allDetails.at(i).number());
    }*/

    m_NameStrings.append(tempQStringList);
}

void horizontalcall::init()
{
    //existingLetterButtons->clear();
    //existingLetters->clear();
    //m_NameStrings.clear();
    row = col = currentLetter = 0;
}

void horizontalcall::destroyLandscapeUI()
{
    qDebug("Main Thread : Destroying Landscape UI");
    leftWidget->close();
    rightWidget->close();
    delete mainLayout;
}

void horizontalcall::destroyPortraitUI()
{
    qDebug("Main Thread : Destroying Portrait UI");
    topWidget->close();
    middleWidget->close();
    //lettersGridLayoutWidget->close();
    delete mainLayoutPortrait;
}

void horizontalcall::minimizeButtonClicked()
{
    if (isFullScreen())
    {
        this->showNormal();
        AppSettingsManager::setShouldLaunchFullscreen(false);
    }
    else
    {
        this->showFullScreen();
        AppSettingsManager::setShouldLaunchFullscreen(true);
    }
}

void horizontalcall::createStyle()
{
    m_StyleLetters =
            "QPushButton {\
                          min-height: 1.5em;\
                          font: 1em;\
                              margin: 0 1px 0 1px;\
                                  color: white;\
                                      background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #2198c0, stop: 1 #0d5ca6);\
                                      border-style: outset;\
                                      border-radius: 3px;\
                                      border-width: 1px;\
                                      border-color: #0c457e;\
                                      font-size: 40px;\
                                  }\
QPushButton:pressed {\
                     background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #0d5ca6, stop: 1 #2198c0);\
                 }";
    getExternalStyleSheet(&m_StyleLetters, "/opt/horizontal-call/styleSheets/styleSheetLetters.qss");
    m_StyleLettersSmaller =
            "QPushButton {\
                          min-height: 1.5em;\
                          font: 1em;\
                              margin: 0 1px 0 1px;\
                                  color: white;\
                                      background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #2198c0, stop: 1 #0d5ca6);\
                                      border-style: outset;\
                                      border-radius: 3px;\
                                      border-width: 1px;\
                                      border-color: #0c457e;\
                                      font-size: 32px;\
                                  }\
QPushButton:pressed {\
                     background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #0d5ca6, stop: 1 #2198c0);\
                 }";
    getExternalStyleSheet(&m_StyleLettersSmaller, "/opt/horizontal-call/styleSheets/styleSheetLettersSmaller.qss");
    m_StylePhoneNumbers =
            "QPushButton {\
                          min-height: 1.5em;\
                          font: 1em;\
                              margin: 0 1px 0 1px;\
                                  color: white;\
                                      background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #2198c0, stop: 1 #0d5ca6);\
                                      border-style: outset;\
                                      border-radius: 3px;\
                                      border-width: 1px;\
                                      border-color: #0c457e;\
                                      font-size: 80px;\
                                  }\
QPushButton:pressed {\
                     background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #0d5ca6, stop: 1 #2198c0);\
                 }";
    getExternalStyleSheet(&m_StylePhoneNumbers, "/opt/horizontal-call/styleSheets/styleSheetPhoneNumbers.qss");
    m_StylePhoneNumbersShort =
            "QPushButton {\
                          min-height: 1.5em;\
                          font: 1em;\
                              margin: 0 1px 0 1px;\
                                  color: white;\
                                      background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #2198c0, stop: 1 #0d5ca6);\
                                      border-style: outset;\
                                      border-radius: 3px;\
                                      border-width: 1px;\
                                      border-color: #0c457e;\
                                      font-size: 60px;\
                                  }\
QPushButton:pressed {\
                     background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #0d5ca6, stop: 1 #2198c0);\
                 }";
    getExternalStyleSheet(&m_StylePhoneNumbersShort, "/opt/horizontal-call/styleSheets/styleSheetPhoneNumbersShort.qss");
    m_StyleQListWidget =
            "QListWidget {\
                          font-size: 30px;\
                      }";
    getExternalStyleSheet(&m_StyleQListWidget, "/opt/horizontal-call/styleSheets/styleSheetQListWidget.qss");
}

void horizontalcall::clearButtonClicked()
{
    qDebug() << "Clear Button Clicked";
    //this->setUpdatesEnabled(false);
    if (m_scrollArea != NULL) {
        m_scrollArea->close();
        m_scrollArea = NULL;
        lineEditFilter->end(false);
        lineEditFilter->cursorBackward(true);
        lineEditFilter->del();
        lineEditTextChanged(lineEditFilter->text());
    } else {
        lineEditFilter->end(false);
        lineEditFilter->cursorBackward(true);
        lineEditFilter->del();
        lineEditTextChanged(lineEditFilter->text());
    }
    //this->setUpdatesEnabled(true);
}

void horizontalcall::lineEditTextChanged(QString text)
{
    m_CurrentFilter = text;
    m_DisplayingContact = false;
    pushButtonClear->setText("<");
    if (m_scrollArea != NULL) {
        m_scrollArea->close();
        m_scrollArea = NULL;
    }
    m_VisibleItem = listWidgetFiltered->count();
    if (text == "") {
        for (int i = 0; i < listWidgetFiltered->count(); i++)
        {
            listWidgetFiltered->item(i)->setHidden(false);
        }
    } else {
        for (int i = 0; i < m_NameStrings.count(); i++)
        {
            bool foundMatch = false;

            for (int k = 0; k < m_NameStrings.at(i).count(); k++)
            {
                if (((QString)m_NameStrings.at(i).at(k)).toUpper().startsWith(lineEditFilter->text().toUpper()))
                {
                    foundMatch = true;
                }
            }

            if (!foundMatch)
            {
                listWidgetFiltered->item(i)->setHidden(true);
                m_VisibleItem--;
            } else {
                listWidgetFiltered->item(i)->setHidden(false);
                m_LastVisibleItemRow = i;
            }
        }
    }

    deleteLetters();
    if (m_VisibleItem == 1)
    {
        m_DisplayingContact = true;
        m_CurrentRow = m_LastVisibleItemRow;
        showContactDetails(m_LastVisibleItemRow);
        listWidgetFiltered->setCurrentRow(m_LastVisibleItemRow);
    } else {
        scanContacts();
        createLetters();
    }
    //this->setUpdatesEnabled(true);
}

void horizontalcall::createLetters()
{
    qDebug() << "Main Thread : Size : " << existingLetters->size();
    for (int i = 0; i < existingLetters->size(); i++)
    {
        CreateLetter(existingLetters->at(i));
    }

    m_showingContactOptions = false;
}

void horizontalcall::deleteLetters()
{
    for (int i = 0; i < existingLetterButtons->size(); i++)
    {
        QPushButton *tempButton = existingLetterButtons->at(i);
        delete tempButton;
    }
    existingLetterButtons->clear();
    row = col = 0;
}

void horizontalcall::exitButtonClicked()
{

    close();
}

void horizontalcall::scanContacts()
{
    //qDebug() << "Main Thread : Scanning Contacts - Namestrings size is : " << m_NameStrings.size();
    existingLetters->clear();
    for (int i = 0; i < (m_NameStrings.count()); i++)
    {

        for (int j = 0; j < m_NameStrings.at(i).count(); j++)
        {
            qDebug() << "Main Thread : Running scan contacts";
            if (m_NameStrings.at(i).at(j).length() <= lineEditFilter->text().length())
            {
                continue;
            }
            QString temp = m_NameStrings.at(i).at(j).at(lineEditFilter->text().size());

            if (!existingLetters->contains(temp.toUpper()) &&
                !listWidgetFiltered->item(i)->isHidden() &&
                temp.at(0) != '\0' &&
                ((QString)m_NameStrings.at(i).at(j)).toUpper().startsWith(lineEditFilter->text().toUpper()))
            {
                //qDebug() << "Main Thread : Adding : '" << temp << "' to existing letters";
                existingLetters->append(temp.toUpper());
            }
        }
    }
    qSort(*existingLetters);
}

void horizontalcall::makeDbusGSMCall(QString number)
{
    QDBusMessage msg = QDBusMessage::createMethodCall(
            "com.nokia.csd.Call", // --dest
            "/com/nokia/csd/call", // destination object path
            "com.nokia.csd.Call", // message name (w/o method)
            "CreateWith" // method
            );
    msg << number;
    msg << 0;
    msg = QDBusConnection::systemBus().call(msg);
}

void horizontalcall::Copy_m_Contacts(QList<QtMobility::QContact> i_Contacts)
{
    m_Contacts = i_Contacts;
    qDebug() << "Main Thread : Copied m_Contacts, size is : " << m_Contacts.size();
}

void horizontalcall::contactNameClicked()
{
    showContactDetails(m_CurrentRow);
}

void horizontalcall::showContactDetails(int row)
{
    qDebug() << "Main Thread : Printing contact in row : " << row;
    pushButtonClear->setText("Back");
    deleteLetters();
    m_CurrentRow = row;

    if (m_scrollArea != NULL) {
        m_scrollArea->close();
        m_scrollArea = NULL;
    }

    m_scrollArea = new QScrollArea();
    m_scrollArea->setAttribute(Qt::WA_DeleteOnClose);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    lettersGridLayout->addWidget(m_scrollArea, 0, 0);
    m_scrollArea->show();


    QWidget *myWidget = new QWidget(m_scrollArea);
    myWidget->setLayout(new QVBoxLayout());

    m_scrollArea->setWidget(myWidget);
    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->widget()->layout()->setContentsMargins(0,0,0,0);
    m_scrollArea->widget()->layout()->setSpacing(0);
    myWidget->show();


    QPushButton *aButton = new QPushButton(listWidgetFiltered->item(row)->text(), myWidget);
    aButton->setStyleSheet("font-size: 43px");
    aButton->setMaximumSize(10000,70);
    m_scrollArea->widget()->layout()->addWidget(aButton);
    aButton->show();

    connect(aButton, SIGNAL(clicked()), this, SLOT(contactNameClicked()));


    QContact a = m_Contacts.at(row);
    qDebug("Main Thread : " + a.displayLabel().toAscii());

    QList<QContactPhoneNumber> allDetails = a.details<QContactPhoneNumber>();
    m_DisplayedPhoneNumbersButtons.clear();

    for (int i = 0; i < allDetails.size(); i++) {

        QPushButton *aButton = new QPushButton(allDetails.at(i).number(), myWidget);
        m_DisplayedPhoneNumbersButtons.append(aButton);
        aButton->sizePolicy().setVerticalPolicy(QSizePolicy::Expanding);
        if (aButton->text().length() > 11) {
            aButton->setStyleSheet(m_StylePhoneNumbersShort);
        } else {
            aButton->setStyleSheet(m_StylePhoneNumbers);
        }
        aButton->setMaximumSize(10000,10000);
        m_scrollArea->widget()->layout()->addWidget(aButton);
        aButton->show();
        connect(aButton, SIGNAL(clicked()),this, SLOT(phoneNumberClicked()));

    }

    QContact temp = m_Contacts.at(row);
    QString myString = temp.detail(QContactPhoneNumber::DefinitionName).value(QContactPhoneNumber::FieldNumber);

    //pushButtonDial->setText(myString);
    //this->setUpdatesEnabled(true);
    m_DisplayingContact = true;
}

void horizontalcall::phoneNumberClicked()
{
    qDebug() << "Phone number button clicked";
    QPushButton *tempButton = qobject_cast<QPushButton *>(QObject::sender());
    m_Phonenumber = tempButton->text();

    /*for (int i = 1; i < m_scrollArea->widget()->layout()->count();i++) {
        qDebug() << "Deleting widget";
        //QLayoutItem *layoutItemToDelete = m_scrollArea->widget()->layout()->itemAt(i);
        m_scrollArea->widget()->layout()->removeItem(m_scrollArea->widget()->layout()->itemAt(i));
    }*/
    for (int i = 0; i < m_DisplayedPhoneNumbersButtons.count(); i++)
    {
        delete m_DisplayedPhoneNumbersButtons.at(i);
    }

    callNumberButton = new QPushButton(m_scrollArea->widget());
    sendSMSButton = new QPushButton(m_scrollArea->widget());
    callNumberButton->setText("Call");
    callNumberButton->setStyleSheet(m_StylePhoneNumbersShort);
    callNumberButton->sizePolicy().setVerticalPolicy(QSizePolicy::Expanding);
    callNumberButton->setMaximumHeight(1000000);
    sendSMSButton->setText("SMS");
    sendSMSButton->setStyleSheet(m_StylePhoneNumbersShort);
    sendSMSButton->sizePolicy().setVerticalPolicy(QSizePolicy::Expanding);
    sendSMSButton->setMaximumHeight(1000000);
    m_scrollArea->widget()->layout()->addWidget(callNumberButton);
    m_scrollArea->widget()->layout()->addWidget(sendSMSButton);

    connect(callNumberButton, SIGNAL(clicked()),this, SLOT(callNumber()));
    connect(sendSMSButton, SIGNAL(clicked()),this, SLOT(sendSMS()));

    m_showingContactOptions = true;
}

void horizontalcall::sendSMS()
{
    qDebug() << "Main Thread : SMS";
    m_CallButtons.append(sendSMSButton);
    QString temp = sendSMSButton->text();
    m_PhoneNumbers.append(new QString("SMS"));
    sendSMSButton->setText("Sending sms...");
    QTimer::singleShot(2000, this, SLOT(enableButtons()));
    sendSMSButton->setEnabled(false);
    sendFastSMS(m_Phonenumber);
}

void horizontalcall::callNumber()
{
    qDebug() << "Main Thread : Call";
    m_CallButtons.append(callNumberButton);
    QString temp = callNumberButton->text();
    m_PhoneNumbers.append(new QString("Call"));
    callNumberButton->setText("Dialing...");
    QTimer::singleShot(2000, this, SLOT(enableButtons()));
    callNumberButton->setEnabled(false);
    makeDbusGSMCall(m_Phonenumber);
}

void horizontalcall::sendFastSMS(QString number)
{
    qDebug() << "Sending SMS to : " << number;
    QDBusMessage msg = QDBusMessage::createMethodCall(
            "it.rsc.fastsms", // --dest
            "/", // destination object path
            "it.rsc.fastsms", // message name (w/o method)
            "addRecipient" // method
            );

    QList<QVariant> args;
    args.append(number);
    args.append("NoName");
    //msg << QString(number);
    //msg << QString("NoName");
    //msg << 0;
    msg.setArguments(args);
    msg = QDBusConnection::sessionBus().call(msg);
    bool ok = msg.type() != QDBusMessage::ErrorMessage;
    qDebug() << msg.errorMessage();
    if(!ok)
    {
        qDebug() << "Error!";
        QMaemo5InformationBox::information(this, "Install fastSMS to <b>Enable</b> this feature.", QMaemo5InformationBox::DefaultTimeout);
    }
}

void horizontalcall::enableButtons()
{
    qDebug() << "Enabling Buttons";
    m_CallButtons.at(0)->setEnabled(true);
    m_CallButtons.at(0)->setText(*m_PhoneNumbers.at(0));
    m_CallButtons.removeFirst();
    m_PhoneNumbers.removeFirst();
}

void horizontalcall::itemClicked(QModelIndex model)
{
    qDebug() << "Main Thread : Row Clicked";
    showContactDetails(model.row());
    m_CurrentRow = model.row();
}

bool horizontalcall::getExternalStyleSheet(QString *styleSheet, QString fileName)
{
    QFile qss(fileName);
    if (!qss.exists())
    {
        qDebug("Main Thread : Style sheet file not found.");
        return false;
    }

    qss.open(QFile::ReadOnly);
    QString styleSheetData = (qss.readAll());
    qss.close();

    *styleSheet = styleSheetData;
    return true;
}

void horizontalcall::resetButtonClicked()
{
    lineEditFilter->setText("");
    lineEditTextChanged("");
}

void horizontalcall::CreateLetter(QString letter)
{
    QPushButton *myButton;
    myButton = new QPushButton(centralWidget());

    //http://wiki.forum.nokia.com/index.php/CS001501_-_Creating_a_gradient_background_for_a_QPushButton_with_style_sheet

    if (existingLetters->size() > 30)
        myButton->setStyleSheet(m_StyleLettersSmaller);
    else
        myButton->setStyleSheet(m_StyleLetters);
    myButton->setMaximumSize(10000,10000);
    myButton->setMinimumSize(0,0);
    myButton->sizePolicy().setVerticalPolicy(QSizePolicy::Expanding);
    myButton->sizePolicy().setHorizontalPolicy(QSizePolicy::Expanding);
    existingLetterButtons->insert(existingLetterButtons->size(),myButton);
    myButton->setText(letter.toUpper());
    connect(myButton, SIGNAL(clicked()), this, SLOT(insertChar()));
    lettersGridLayout->addWidget(myButton, col, row);
    if (row == numberOfLettersPerRow - 1)
    {
        row = 0;
        col++;
    } else {
        row++;
    }
    myButton->show();
}

void horizontalcall::insertChar()
{
    QPushButton *tempButton = qobject_cast<QPushButton *>(QObject::sender());
    lineEditFilter->insert(tempButton->text());
    qDebug() << "Button Clicked";
    lineEditTextChanged(lineEditFilter->text());
}

horizontalcall::~horizontalcall()
{
    delete ui;
}
