#ifndef HORIZONTALCALL_H
#define HORIZONTALCALL_H

#include <QtGui>
#include <QContact>
#include <QContactPhoneNumber>
#include <QMessageBox>

//Added for dbus service
#include <QMainWindow>
#include <QCloseEvent>
// ---------------------

#include "contactsthreadworker.h"
#include "qtmaemo5rotator.h"

#define APP_DBUS_PATH "/com/eitam/horizontalcall"
#define APP_DBUS_SERVICE "com.eitam.horizontalcall"
#define APP_DBUS_INTERFACE "com.eitam.horizontalcall"

namespace Ui {
    class horizontalcall;
}

class horizontalcall : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.eitam.horizontalcall")

public slots:
    void clearButtonClicked();
    void exitButtonClicked();
    void itemClicked(QModelIndex model);
    void insertChar();
    void lineEditTextChanged(QString text);
    void phoneNumberClicked();
    void enableButtons();
    void resetButtonClicked();
    void minimizeButtonClicked();
    void doAction1();//Auto Rotation
    void doAction2();//Manual Rotation
    void doAction3();//Refresh Contacts
    //void doAction4();//Options Menu
    void AddContact(QtMobility::QContact temp);
    void ContactUpdatesDone();
    void Copy_m_Contacts(QList<QtMobility::QContact>);
    void fetchContacts();
    void callNumber();
    void sendSMS();
    void contactNameClicked();
    Q_SCRIPTABLE int top_application();

signals:
    void getContacts();

public:
    explicit horizontalcall(QWidget *parent = 0);
    QThread *m_myThread;
    ~horizontalcall();

protected:
    void resizeEvent(QResizeEvent *e);

private:
    //Members

    //Added for dbus service
    void closeEvent(QCloseEvent *event);
    // ---------------------
    Ui::horizontalcall *ui;
    QtMaemo5Rotator *rotator;
    QList<QPushButton*> *existingLetterButtons;
    QList<QString> *existingLetters;
    QList<QtMobility::QContact> m_Contacts;
    QtMobility::QContactFetchRequest *m_FetchRequest;
    QString abc;
    QScrollArea *m_scrollArea;
    QString m_StyleLetters;
    QString m_StyleLettersSmaller;
    QString m_StylePhoneNumbers;
    QString m_StylePhoneNumbersShort;
    QString m_StyleQListWidget;
    QString m_CurrentFilter;
    QString m_LabelSelector;
    int m_CurrentRow;
    QList<QPushButton*> m_CallButtons;
    QList<QString*> m_PhoneNumbers;
    QList<QStringList> m_NameStrings;
    int currentLetter;
    int numberOfLettersPerRow;
    int row, col;
    int m_VisibleItem;
    int m_LastVisibleItemRow;
    bool m_Landscape;
    bool m_FetchPending;
    bool m_DisplayingContact;
    bool m_AutorotationEnabled;
    bool m_showingContactOptions;
    QList<QPushButton*> m_DisplayedPhoneNumbersButtons;
    QString m_Phonenumber;
    QPushButton *callNumberButton;
    QPushButton *sendSMSButton;

    //----------------- Shared UI Members -----------------
    //Layouts / Container Widgets
    QWidget     *windowControlsWidget;
    QGridLayout *lettersGridLayout;
    QWidget     *lettersGridLayoutWidget;

    //Componenets
    QLineEdit   *lineEditFilter;
    QPushButton *pushButtonClear;
    QPushButton *pushButtonReset;
    QPushButton *pushButtonMinimize;
    QPushButton *pushButtonExit;
    QListWidget *listWidgetFiltered;
    QLabel      *labelSelector;
    QAction     *action1;
    QAction     *action2;
    QAction     *action3;
    QMenu       *menu;
    //--------------------------------------------------------

    //----------------- Landscape UI Members -----------------
    //Layouts
    QWidget     *leftWidget;
    QWidget     *rightWidget;
    QWidget     *filterControlsWidget;
    QHBoxLayout *mainLayout;
    QVBoxLayout *leftLayout;
    QVBoxLayout *rightLayout;
    QHBoxLayout *filterControlsLayout;
    QHBoxLayout *windowControlsLayout;

    //--------------------------------------------------------

    //----------------- Portrait UI Members ------------------
    //Layouts
    QWidget     *topWidget;
    QWidget     *middleWidget;
    QVBoxLayout *mainLayoutPortrait;
    QHBoxLayout *topLayout;
    QHBoxLayout *middleLayout;
    QVBoxLayout *windowControlsLayoutPortrait;
    //--------------------------------------------------------


    // Methods
    bool getExternalStyleSheet(QString *styleSheet, QString fileName);
    void scanContacts();
    void deleteLetters();
    void createLetters();
    void getContactDetails(QString contactName);
    void makeDbusGSMCall(QString number);
    void sendFastSMS(QString number);
    void showContactDetails(int row);
    void CreateLetter(QString letter);
    void createStyle();
    void init();
    void fillListWidget();
    void getRotationSettings();

    // UI Methods
    void createPortraitUI();
    void createLandscapeUI();
    void createSharedUI();
    void destroyLandscapeUI();
    void destroyPortraitUI();
    //void setAutoRotation(bool i_On);
};

#endif // HORiZONTALCALL_H
