
#include "qtmaemo5rotator.h"

#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#endif

QtMaemo5Rotator::QtMaemo5Rotator(RotationBehavior behavior, QWidget *parent)
    : QObject(parent),
    _isSetUp(false)
{
    setCurrentBehavior(behavior);
}

QtMaemo5Rotator::~QtMaemo5Rotator()
{
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
    QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_DISABLE_REQ));
#endif
}

const QtMaemo5Rotator::RotationBehavior QtMaemo5Rotator::currentBehavior()
{
    return _currentBehavior;
}

const QtMaemo5Rotator::Orientation QtMaemo5Rotator::currentOrientation()
{
    return _currentOrientation;
}

void QtMaemo5Rotator::setCurrentBehavior(QtMaemo5Rotator::RotationBehavior value)
{
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
    if (value == _currentBehavior && _isSetUp)
        return;

    _isSetUp = true;
    _currentBehavior = value;

    if (value == QtMaemo5Rotator::AutomaticBehavior)
    {
        QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_ENABLE_REQ));
        QDBusConnection::systemBus().connect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF, MCE_DEVICE_ORIENTATION_SIG, this, SLOT(on_orientation_changed(QString)));

        on_orientation_changed(QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_DEVICE_ORIENTATION_GET)).arguments().first().toString());
    }
    else
    {
        QDBusConnection::systemBus().disconnect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF, MCE_DEVICE_ORIENTATION_SIG, this, SLOT(on_orientation_changed(QString)));
        QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_DISABLE_REQ));

        if (value == QtMaemo5Rotator::PortraitBehavior)
        {
            setCurrentOrientation(QtMaemo5Rotator::PortraitOrientation);
        }
        else
        {
            setCurrentOrientation(QtMaemo5Rotator::LandscapeOrientation);
        }
    }
#endif
}

void QtMaemo5Rotator::setCurrentOrientation(QtMaemo5Rotator::Orientation value)
{
    _currentOrientation = value;
    QWidget *par = (QWidget*)parent();

    switch (value)
    {
    case QtMaemo5Rotator::PortraitOrientation:
        qDebug() << "portrait orientation is set now";
        if (par != NULL)
        {
#if defined(Q_WS_MAEMO_5)
            par->setAttribute(Qt::WA_Maemo5LandscapeOrientation, false);
            par->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
#endif
        }
        orientationChanged(QtMaemo5Rotator::PortraitOrientation);
        break;
    case QtMaemo5Rotator::LandscapeOrientation:
        qDebug() << "landscape orientation is set now";
        if (par != NULL)
        {
#if defined(Q_WS_MAEMO_5)
            par->setAttribute(Qt::WA_Maemo5PortraitOrientation, false);
            par->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
#endif
        }
        orientationChanged(QtMaemo5Rotator::LandscapeOrientation);

        break;
    }
}

void QtMaemo5Rotator::on_orientation_changed(const QString& newOrientation)
{
    if (newOrientation == QLatin1String(MCE_ORIENTATION_PORTRAIT) || newOrientation == QLatin1String(MCE_ORIENTATION_PORTRAIT_INVERTED))
    {
        setCurrentOrientation(QtMaemo5Rotator::PortraitOrientation);
    }
    else
    {
        setCurrentOrientation(QtMaemo5Rotator::LandscapeOrientation);
    }
    QApplication::desktop()->updateGeometry();
}
