#include "contactsthreadworker.h"

using namespace QtMobility;

ContactsThreadWorker::ContactsThreadWorker()
    : QThread(0)
{
}

void ContactsThreadWorker::run()
{
    this->exec();
}

void ContactsThreadWorker::getContacts()
{
    qDebug() << "ContactsThreadWorker : Got signal to get contacts - Invoking getContactsFromMemory.";
    getContactsFromMemory();
}

bool ContactsThreadWorker::doesPhoneNumberExist(QContact *i_Contact)
{
    bool foundPhoneNumber = false;
    QList<QContactDetail> details = i_Contact->details();
    for (int z=0;z < details.size(); z++)
    {
        qDebug() << "ContactsThreadWorker : Scanning contact for phone number";
        QString temp = details.at(z).definitionName();
        if (temp == "PhoneNumber") {
            foundPhoneNumber = true;
        }
    }

    return foundPhoneNumber;
}

void ContactsThreadWorker::contactsReady()
{
    qDebug("ContactsThreadWorker : Contacts are now ready.");
    m_Contacts = m_FetchRequest->contacts();
    qDebug() << "ContactsThreadWorker : Got " << m_Contacts.size() << " Recrods in m_Contacts";
    updateAllContacts();
}

void ContactsThreadWorker::updateContactsAgain()
{
    qDebug() << "ContactsThreadWorker : Updating contacts once more.";
    updateAllContacts();
}

bool ContactsThreadWorker::isAllEnglish(QString label)
{
    bool retVal = true;
    for (int i = 0; i < label.length(); i++)
    {
        qDebug() << "Scanning contact for Englush chars";
        if (!(label.at(i) >= 32 && label.at(i) <= 126))
        {
            retVal = false;
        }
    }

    return retVal;
}

void ContactsThreadWorker::updateAllContacts()
{
    for (int i = 0; i < m_Contacts.size(); i++)
    {
        qDebug() << "Updating contact : " << i;
        QContact temp = m_Contacts.at(i);
        QContactDisplayLabel displayLabel = temp.detail(QContactDisplayLabel::DefinitionName);

        if (!isAllEnglish(displayLabel.label()))
        {
            m_Contacts.removeAt(i);
            i--;
            continue;
        }

        if (!doesPhoneNumberExist(&temp))
        {
            m_Contacts.removeAt(i);
            i--;
            continue;
        }

        qDebug() << "ContactsThreadWorker : Emitting contact : " << i << " - Named : " << temp.displayLabel();
        emit updateContact(temp);
    }

    qDebug() << "ContactsThreadWorker : Finished updating contacts.";
    emit copy_m_Contacts(m_Contacts);
    emit DoneUpdatingContacts();
}

void ContactsThreadWorker::getContactsFromMemory()
{
    QContactManager *pManager = new QContactManager();
    m_FetchRequest = new QContactFetchRequest();
    m_FetchRequest->setManager(pManager);
    QContactSortOrder nameOrder;
    nameOrder.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldFirstName);
    m_FetchRequest->setSorting(QList<QContactSortOrder>() << nameOrder);
    connect(m_FetchRequest, SIGNAL(resultsAvailable()), this, SLOT(contactsReady()));

    // async
    if (!m_FetchRequest->start()) {
        qDebug() << "ContactsThreadWorker : Unable to schedule a contacts fetch.";
    }
}
