#include <QtGui/QApplication>
#include "horizontalcall.h"
#include "contactsthreadworker.h"
#include "appsettingsmanager.h"
#include <QDBusConnection>
#include <QDBusError>

int main(int argc, char *argv[])
{
    QApplication::setApplicationName("horizontal-call");
    QApplication::setOrganizationName("Eitama");

    QApplication app(argc, argv);
    horizontalcall window;
    ContactsThreadWorker myThread;

    qRegisterMetaType<QtMobility::QContact>("QtMobility::QContact");
    qRegisterMetaType<QList <QtMobility::QContact> >("QList<QtMobility::QContact>");

    QObject::connect(&myThread, SIGNAL(copy_m_Contacts(QList<QtMobility::QContact>)), &window, SLOT(Copy_m_Contacts(QList<QtMobility::QContact>)),Qt::QueuedConnection);
    QObject::connect(&myThread, SIGNAL(updateContact(QtMobility::QContact)), &window, SLOT(AddContact(QtMobility::QContact)),Qt::QueuedConnection);
    QObject::connect(&myThread, SIGNAL(DoneUpdatingContacts()), &window, SLOT(ContactUpdatesDone()),Qt::QueuedConnection);
    myThread.start();

    if (AppSettingsManager::shouldLaunchFullscreen())
        window.showFullScreen();
    else
        window.showNormal();

    if (!QDBusConnection::sessionBus().isConnected()) {
        qWarning("Cannot connect to the D-Bus session bus.");
        exit(1);
    }

    if (!QDBusConnection::sessionBus().registerService("com.eitam.horizontalcall")) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
            message()));
        exit(2);
    }

    if (!QDBusConnection::sessionBus().registerObject("/com/eitam/horizontalcall", &window,
            QDBusConnection::ExportScriptableSlots)) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
            message()));
        exit(3);
    }

    return app.exec();
}
