#ifndef HORIZONTALCALL_H
#define HORIZONTALCALL_H

#include <QtGui>
#include <QContact>
#include <QContactPhoneNumber>

#include "contactsthreadworker.h"
#include "qtmaemo5rotator.h"

namespace Ui {
    class horizontalcall;
}

class horizontalcall : public QMainWindow
{
    Q_OBJECT

public slots:
    void clearButtonClicked();
    void exitButtonClicked();
    void itemClicked(QModelIndex model);
    void insertChar();
    void lineEditTextChanged(QString text);
    void phoneNumberClicked();
    void enableButtons();
    void resetButtonClicked();
    void minimizeButtonClicked();
    void doAction1();
    void doAction2();
    void AddContact(QtMobility::QContact temp);
    void ContactUpdatesDone();
    void Copy_m_Contacts(QList<QtMobility::QContact>);

signals:

public:
    explicit horizontalcall(QWidget *parent = 0);
    ~horizontalcall();

protected:
    void resizeEvent(QResizeEvent *e);

private:
    //Members
    Ui::horizontalcall *ui;
    QtMaemo5Rotator *rotator;
    QList<QPushButton*> *existingLetterButtons;
    QList<QString> *existingLetters;
    QList<QtMobility::QContact> m_Contacts;
    QtMobility::QContactFetchRequest *m_FetchRequest;
    QString abc;
    QScrollArea *m_scrollArea;
    QString m_StyleLetters;
    QString m_StyleLettersSmaller;
    QString m_StylePhoneNumbers;
    QString m_StylePhoneNumbersShort;
    QString m_StyleQListWidget;
    QString m_CurrentFilter;
    QString m_LabelSelector;
    int m_CurrentRow;
    QList<QPushButton*> m_CallButtons;
    QList<QString*> m_PhoneNumbers;
    QList<QStringList> m_NameStrings;
    int currentLetter;
    int numberOfLettersPerRow;
    int row, col;
    int m_VisibleItem;
    int m_LastVisibleItemRow;
    bool m_Landscape;
    bool m_FetchPending;
    bool m_DisplayingContact;
    bool m_AutorotationEnabled;

    //----------------- Shared UI Members -----------------
    //Layouts / Container Widgets
    QWidget     *windowControlsWidget;
    QGridLayout *lettersGridLayout;
    QWidget     *lettersGridLayoutWidget;

    //Componenets
    QLineEdit   *lineEditFilter;
    QPushButton *pushButtonClear;
    QPushButton *pushButtonReset;
    QPushButton *pushButtonMinimize;
    QPushButton *pushButtonExit;
    QListWidget *listWidgetFiltered;
    QLabel      *labelSelector;
    QAction     *action1;
    QAction     *action2;
    QMenu       *menu;
    //--------------------------------------------------------

    //----------------- Landscape UI Members -----------------
    //Layouts
    QWidget     *leftWidget;
    QWidget     *rightWidget;
    QWidget     *filterControlsWidget;
    QHBoxLayout *mainLayout;
    QVBoxLayout *leftLayout;
    QVBoxLayout *rightLayout;
    QHBoxLayout *filterControlsLayout;
    QHBoxLayout *windowControlsLayout;

    //--------------------------------------------------------

    //----------------- Portrait UI Members ------------------
    //Layouts
    QWidget     *topWidget;
    QWidget     *middleWidget;
    QVBoxLayout *mainLayoutPortrait;
    QHBoxLayout *topLayout;
    QHBoxLayout *middleLayout;
    QVBoxLayout *windowControlsLayoutPortrait;
    //--------------------------------------------------------


    // Methods
    bool getExternalStyleSheet(QString *styleSheet, QString fileName);
    void scanContacts();
    void deleteLetters();
    void createLetters();
    void getContactDetails(QString contactName);
    void makeDbusGSMCall(QString number);
    void showContactDetails(int row);
    void CreateLetter(QString letter);
    void createStyle();
    void init();
    void fillListWidget();
    void getRotationSettings();

    // UI Methods
    void createPortraitUI();
    void createLandscapeUI();
    void createSharedUI();
    void destroyLandscapeUI();
    void destroyPortraitUI();
    //void setAutoRotation(bool i_On);
};

#endif // HORiZONTALCALL_H
