#ifndef HORIZONTALCALL_H
#define HORIZONTALCALL_H

#include <QMainWindow>
#include <QModelIndex>
#include <QContact>
#include <QContactName>
#include <QContactSortOrder>
#include <QContactManager>
#include <QContactFetchRequest>
#include <QTimer>
#include <QPushButton>
#include <QToolButton>
#include <QDBusMessage>
#include <QDBusConnection>
#include <QContactPhoneNumber>
#include <QScrollArea>
#include <QFile>
#include <QtDebug>
#include <QGridLayout>

namespace Ui {
    class horizontalcall;
}

class horizontalcall : public QMainWindow
{
    Q_OBJECT

public slots:
    void clearButtonClicked();
    void exitButtonClicked();
    void itemClicked(QModelIndex model);
    void printContacts();
    void populateList();
    void insertChar();
    void lineEditTextChanged(QString text);
    void phoneNumberClicked();
    void enableButtons();
    void resetButtonClicked();
    void minimizeButtonClicked();
    //void orientationChanged();

public:
    explicit horizontalcall(QWidget *parent = 0);
    ~horizontalcall();

private:
    //Members
    Ui::horizontalcall *ui;
    QList<QPushButton*> *existingLetterButtons;
    QList<QString> *existingLetters;
    QList<QtMobility::QContact> m_Contacts;
    QtMobility::QContactFetchRequest *m_FetchRequest;
    QString abc;
    QScrollArea *m_scrollArea;
    QString m_StyleLetters;
    QString m_StylePhoneNumbers;
    QString m_StylePhoneNumbersShort;
    QString m_StyleQListWidget;
    QList<QPushButton*> m_CallButtons;
    QList<QString*> m_PhoneNumbers;
    QList<QStringList> m_NameStrings;
    QGridLayout *gridLayoutLetters;
    int currentLetter;
    int numberOfLettersPerRow;
    int row, col;
    int m_VisibleItem;
    int m_LastVisibleItemRow;
    bool m_Maximized;

    // Methods
    bool getExternalStyleSheet(QString *styleSheet, QString fileName);
    bool isAllEnglish(QString label);
    bool doesPhoneNumberExist(QtMobility::QContact *i_Contact);
    void getContactsFromMemory();
    void populateListWidget();
    void scanContacts();
    void deleteLetters();
    void createLetters();
    void getContactDetails(QString contactName);
    void makeDbusGSMCall(QString number);
    void showContactDetails(int row);
    void CreateLetter(QString letter);
    void createStyle();
    void init();
    //void setAutoRotation(bool i_On);
};

#endif // HORiZONTALCALL_H
