#include "horizontalcall.h"
#include "ui_horizontalcall.h"

using namespace QtMobility;

horizontalcall::horizontalcall(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::horizontalcall)
{
    createStyle();
    ui->setupUi(this);
    ui->listWidgetFiltered->setStyleSheet(m_StyleQListWidget);
    m_VisibleItem = 0;
    m_LastVisibleItemRow = 0;
    m_FetchRequest = new QContactFetchRequest();
    QTimer::singleShot(1000, this, SLOT(populateList()));
    abc = "abcdefghijklmnopqrstuvwxyz";
    numberOfLettersPerRow = 6;
    existingLetterButtons = new QList<QPushButton*>();
    existingLetters = new QList<QString>();
    m_Contacts = QList<QContact>();
    m_scrollArea = NULL;
    init();
}

void horizontalcall::createStyle()
{
    m_StyleLetters =
            "QPushButton {\
                min-height: 1.5em;\
                font: 1em;\
                margin: 0 1px 0 1px;\
                color: white;\
                background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #2198c0, stop: 1 #0d5ca6);\
                border-style: outset;\
                border-radius: 3px;\
                border-width: 1px;\
                border-color: #0c457e;\
                font-size: 40px;\
            }\
            QPushButton:pressed {\
                background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #0d5ca6, stop: 1 #2198c0);\
    }";
    getExternalStyleSheet(&m_StyleLetters, "/opt/horizontal-call/styleSheets/styleSheetLetters.qss");
    m_StylePhoneNumbers =
            "QPushButton {\
                min-height: 1.5em;\
                font: 1em;\
                margin: 0 1px 0 1px;\
                color: white;\
                background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #2198c0, stop: 1 #0d5ca6);\
                border-style: outset;\
                border-radius: 3px;\
                border-width: 1px;\
                border-color: #0c457e;\
                font-size: 80px;\
            }\
            QPushButton:pressed {\
                background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #0d5ca6, stop: 1 #2198c0);\
    }";
    getExternalStyleSheet(&m_StylePhoneNumbers, "/opt/horizontal-call/styleSheets/styleSheetPhoneNumbers.qss");
    m_StylePhoneNumbersShort =
            "QPushButton {\
                min-height: 1.5em;\
                font: 1em;\
                margin: 0 1px 0 1px;\
                color: white;\
                background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #2198c0, stop: 1 #0d5ca6);\
                border-style: outset;\
                border-radius: 3px;\
                border-width: 1px;\
                border-color: #0c457e;\
                font-size: 60px;\
            }\
            QPushButton:pressed {\
                background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #0d5ca6, stop: 1 #2198c0);\
    }";
    getExternalStyleSheet(&m_StylePhoneNumbersShort, "/opt/horizontal-call/styleSheets/styleSheetPhoneNumbersShort.qss");
    m_StyleQListWidget =
            "QListWidget {\
                font-size: 30px;\
    }";
    getExternalStyleSheet(&m_StyleQListWidget, "/opt/horizontal-call/styleSheets/styleSheetQListWidget.qss");
}

void horizontalcall::init()
{
    row = col = currentLetter = 0;
}

void horizontalcall::clearButtonClicked()
{
    if (!m_scrollArea == NULL) {
        m_scrollArea->close();
        m_scrollArea = NULL;
        ui->lineEditFilter->end(false);
        ui->lineEditFilter->cursorBackward(true);
        ui->lineEditFilter->del();
        lineEditTextChanged(ui->lineEditFilter->text());
    } else {
        ui->lineEditFilter->end(false);
        ui->lineEditFilter->cursorBackward(true);
        ui->lineEditFilter->del();
        lineEditTextChanged(ui->lineEditFilter->text());
    }
}

void horizontalcall::lineEditTextChanged(QString text)
{

    ui->pushButtonClear->setText("<");

    if (!m_scrollArea == NULL) {
        m_scrollArea->close();
        m_scrollArea = NULL;
    }
    m_VisibleItem = ui->listWidgetFiltered->count();
    if (text == "") {
        for (int i = 0; i < ui->listWidgetFiltered->count(); i++)
        {
            ui->listWidgetFiltered->item(i)->setHidden(false);
        }
    } else {
        for (int i = 0; i < ui->listWidgetFiltered->count(); i++)
        {
            if (!(ui->listWidgetFiltered->item(i)->text().toUpper().startsWith(ui->lineEditFilter->text().toUpper())))
            {
                ui->listWidgetFiltered->item(i)->setHidden(true);
                m_VisibleItem--;
            } else {
                ui->listWidgetFiltered->item(i)->setHidden(false);
                m_LastVisibleItemRow = i;
            }
        }
    }

    deleteLetters();
    if (m_VisibleItem == 1)
    {
        showContactDetails(m_LastVisibleItemRow);
        ui->labelSelector->setText(QString::number(m_LastVisibleItemRow) + " / " + QString::number(m_Contacts.length()));
        ui->listWidgetFiltered->setCurrentRow(m_LastVisibleItemRow);
    } else {
        scanContacts();
        createLetters();
    }
}

void horizontalcall::createLetters()
{
    for (int i = 0; i < existingLetters->size(); i++)
    {
        CreateLetter(existingLetters->at(i));
    }
}

void horizontalcall::deleteLetters()
{
    for (int i = 0; i < existingLetterButtons->size(); i++)
    {
        QPushButton *tempButton = existingLetterButtons->at(i);
        delete tempButton;
    }
    existingLetterButtons->clear();
    init();
}

void horizontalcall::populateList()
{
    ui->lineEditFilter->insert("Populating List...");
    getContactsFromMemory();
}

void horizontalcall::exitButtonClicked()
{
    exit(0);
}

void horizontalcall::scanContacts()
{
    existingLetters->clear();
    for (int i = 0; i < (ui->listWidgetFiltered->count()); i++)
    {
        //qDebug("Checking contact : " + ui->listWidgetFiltered->item(i)->text().toAscii());

        if (ui->listWidgetFiltered->item(i)->text().length() <= ui->lineEditFilter->text().length())
        {
            continue;
        }
        QString temp = ui->listWidgetFiltered->item(i)->text().at(ui->lineEditFilter->text().size());

        if (!existingLetters->contains(temp.toUpper()) && !ui->listWidgetFiltered->item(i)->isHidden() && temp.at(0) != '\0') {
            existingLetters->append(temp.toUpper());
        }
    }
    qSort(*existingLetters);
}

bool caseInsensitiveLessThan(const QString &s1, const QString &s2)
{
    return s1.toLower() < s2.toLower();
}

void horizontalcall::makeDbusGSMCall(QString number)
{
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.csd.Call", // --dest
        "/com/nokia/csd/call", // destination object path
        "com.nokia.csd.Call", // message name (w/o method)
        "CreateWith" // method
    );
    msg << number;
    msg << 0;
    msg = QDBusConnection::systemBus().call(msg);
}

void horizontalcall::populateListWidget()
{
    getContactsFromMemory();
}

bool horizontalcall::doesPhoneNumberExist(QContact *i_Contact)
{
    bool foundPhoneNumber = false;
    QList<QContactDetail> details = i_Contact->details();
    for (int z=0;z < details.size(); z++)
    {
        QString temp = details.at(z).definitionName();
        if (temp == "PhoneNumber") {
            foundPhoneNumber = true;
        }
    }

    return foundPhoneNumber;
}

void horizontalcall::showContactDetails(int row)
{
    ui->pushButtonClear->setText("Back");
    deleteLetters();

    if (!m_scrollArea == NULL) {
        m_scrollArea->close();
        m_scrollArea = NULL;
    }

    m_scrollArea = new QScrollArea();
    m_scrollArea->setAttribute(Qt::WA_DeleteOnClose);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->gridLayoutLetters->addWidget(m_scrollArea, 0, 0);
    m_scrollArea->show();


    QWidget *myWidget = new QWidget(m_scrollArea);
    myWidget->setLayout(new QVBoxLayout());

    m_scrollArea->setWidget(myWidget);
    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->widget()->layout()->setContentsMargins(0,0,0,0);
    m_scrollArea->widget()->layout()->setSpacing(0);
    myWidget->show();


    QPushButton *aButton = new QPushButton(ui->listWidgetFiltered->item(row)->text(), myWidget);
    aButton->setStyleSheet("font-size: 43px");
    aButton->setMaximumSize(10000,80);
    m_scrollArea->widget()->layout()->addWidget(aButton);
    aButton->show();


    QContact a = m_Contacts.at(row);
    //qDebug(a.displayLabel().toAscii());

    QList<QContactPhoneNumber> allDetails = a.details<QContactPhoneNumber>();

    for (int i = 0; i < allDetails.size(); i++) {

        QPushButton *aButton = new QPushButton(allDetails.at(i).number(), myWidget);
        aButton->sizePolicy().setVerticalPolicy(QSizePolicy::Expanding);
        if (aButton->text().length() > 11) {
            aButton->setStyleSheet(m_StylePhoneNumbersShort);
        } else {
            aButton->setStyleSheet(m_StylePhoneNumbers);
        }
        aButton->setMaximumSize(10000,10000);
        m_scrollArea->widget()->layout()->addWidget(aButton);
        aButton->show();
        connect(aButton, SIGNAL(clicked()),this, SLOT(phoneNumberClicked()));

    }

    QContact temp = m_Contacts.at(row);
    QString myString = temp.detail(QContactPhoneNumber::DefinitionName).value(QContactPhoneNumber::FieldNumber);

    //ui->pushButtonDial->setText(myString);
}

void horizontalcall::phoneNumberClicked()
{
    QPushButton *tempButton = qobject_cast<QPushButton *>(QObject::sender());
    m_CallButtons.append(tempButton);
    QString temp = tempButton->text();
    m_PhoneNumbers.append(new QString(tempButton->text()));
    tempButton->setText("Dialing...");
    QTimer::singleShot(1000, this, SLOT(enableButtons()));
    tempButton->setEnabled(false);
    makeDbusGSMCall(temp);
}

void horizontalcall::enableButtons()
{
    m_CallButtons.at(0)->setEnabled(true);
    m_CallButtons.at(0)->setText(*m_PhoneNumbers.at(0));
    m_CallButtons.removeFirst();
    m_PhoneNumbers.removeFirst();
}

void horizontalcall::itemClicked(QModelIndex model)
{
    //qDebug("Row Clicked : " + QString::number(model.row()).toAscii());
    showContactDetails(model.row());
    ui->labelSelector->setText(QString::number(model.row()) + "/" + QString::number(m_Contacts.length()));
}

void horizontalcall::getContactsFromMemory()
{
    QContactManager *pManager = new QContactManager();
    m_FetchRequest->setManager(pManager);
    QContactSortOrder nameOrder;
    nameOrder.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldFirstName);
    m_FetchRequest->setSorting(QList<QContactSortOrder>() << nameOrder);
    connect(m_FetchRequest, SIGNAL(resultsAvailable()), this, SLOT(printContacts()));

    // async
    if (!m_FetchRequest->start()) {

    }
}

bool horizontalcall::getExternalStyleSheet(QString *styleSheet, QString fileName)
{
    QFile qss(fileName);
    if (!qss.exists())
    {
        qDebug("Style sheet file not found.");
        return false;
    }

    qss.open(QFile::ReadOnly);
    QString styleSheetData = (qss.readAll());
    qss.close();

    *styleSheet = styleSheetData;
    return true;
}

bool horizontalcall::isAllEnglish(QString label)
{
    bool retVal = true;
    for (int i = 0; i < label.length(); i++)
    {
        if (!(label.at(i) >= 32 && label.at(i) <= 126))
        {
            retVal = false;
        }
    }

    return retVal;
}

void horizontalcall::resetButtonClicked()
{
    ui->lineEditFilter->setText("");
    lineEditTextChanged("");
}

void horizontalcall::printContacts()
{
    m_Contacts = m_FetchRequest->contacts();
    //qDebug(QString::number(m_Contacts.length()).toAscii());
    for (int i = 0; i < m_Contacts.size(); i++)
    {
        QContact temp = m_Contacts.at(i);
        //qDebug("Contact number : " + QString::number(i).toAscii() + " Name : " + temp.displayLabel().toAscii());
        QContactDisplayLabel displayLabel = temp.detail(QContactDisplayLabel::DefinitionName);

        if (!isAllEnglish(displayLabel.label()))
        {
            m_Contacts.removeAt(i);
            i--;
            continue;

        }

        if (!doesPhoneNumberExist(&temp))
        {
            m_Contacts.removeAt(i);
            i--;
            continue;
        }

        QList<QContactPhoneNumber> allDetails = temp.details<QContactPhoneNumber>();
        ui->listWidgetFiltered->addItem(displayLabel.label());

    }
    ui->lineEditFilter->clear();

    lineEditTextChanged("");
    ui->labelSelector->setText(QString::number(m_Contacts.length()));
    ui->lineEditFilter->setReadOnly(false);
    //qDebug(QString::number(m_Contacts.size()).toAscii());
}

void horizontalcall::CreateLetter(QString letter)
{
    QPushButton *myButton = new QPushButton();

    //http://wiki.forum.nokia.com/index.php/CS001501_-_Creating_a_gradient_background_for_a_QPushButton_with_style_sheet

    myButton->setStyleSheet(m_StyleLetters);
    myButton->setMaximumSize(10000,10000);
    myButton->setMinimumSize(0,0);
    myButton->sizePolicy().setVerticalPolicy(QSizePolicy::Expanding);
    myButton->sizePolicy().setHorizontalPolicy(QSizePolicy::Expanding);
    existingLetterButtons->insert(existingLetterButtons->size(),myButton);
    myButton->setText(letter.toUpper());
    connect(myButton, SIGNAL(clicked()), this, SLOT(insertChar()));
    ui->gridLayoutLetters->addWidget(myButton, col, row);
    if (row == numberOfLettersPerRow - 1)
    {
        row = 0;
        col++;
    } else {
        row++;
    }
    myButton->show();
}

void horizontalcall::insertChar()
{
    QPushButton *tempButton = qobject_cast<QPushButton *>(QObject::sender());
    ui->lineEditFilter->insert(tempButton->text());
    lineEditTextChanged(ui->lineEditFilter->text());
}

horizontalcall::~horizontalcall()
{
    delete ui;
}
