/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "xmlrpcparser.h"
#include <QDebug>
#include <QXmlStreamReader>

using namespace XmlRpc;

QVariant readArray(QXmlStreamReader* str)
{
	Q_ASSERT(!str->atEnd());
	QXmlStreamReader::TokenType type = str->readNext();
	Q_ASSERT(type==QXmlStreamReader::StartElement && str->name()=="data");
	
	QVariantList ret;
	type = str->readNext();
	while(type != QXmlStreamReader::EndElement) {
		ret += Parser::readValue(str);
		
		type = str->readNext();
	}
	Q_ASSERT(type==QXmlStreamReader::EndElement && str->name()=="data");
	type = str->readNext();
	
	Q_ASSERT(type==QXmlStreamReader::EndElement && str->name()=="array");
	return ret;
}

QVariant readInt(QXmlStreamReader* str)
{
	Q_ASSERT(!str->atEnd());
	QXmlStreamReader::TokenType type = str->readNext();
	Q_ASSERT(type==QXmlStreamReader::Characters);
	int ret = str->text().toString().toInt();
	type = str->readNext();
	Q_ASSERT(type==QXmlStreamReader::EndElement);
	
	return ret;
}

QVariant readString(QXmlStreamReader* str)
{
	Q_ASSERT(!str->atEnd());
	QXmlStreamReader::TokenType type = str->readNext();
	Q_ASSERT(type==QXmlStreamReader::Characters);
	QString ret = str->text().toString();
	
	type = str->readNext();
	Q_ASSERT(type==QXmlStreamReader::EndElement);
	return ret;
}

QMap<QString, Parser::readValues> initializeConverters()
{
	QMap<QString, Parser::readValues> ret;
	ret["array"]=readArray;
	ret["int"]=readInt;
	ret["string"]=readString;
	return ret;
}

static QMap<QString, Parser::readValues> s_converters=initializeConverters();

QVariant Parser::parse(const QByteArray& _data, bool* ok)
{
	QByteArray data(_data.simplified());
	data.replace("> <", "><");
	
	xml = new QXmlStreamReader(data);
	QVariantList param;
	
// 	qDebug() << "prrr" << data;
	
	while (!xml->atEnd()) {
		QXmlStreamReader::TokenType type = xml->readNext();
		if(type == QXmlStreamReader::StartElement) {
			if(xml->name()=="param")
				param += readParam();
		}
	}
	
	*ok = !xml->hasError();
	
	return param;
}

QVariant Parser::readParam()
{
	QVariant ret;
	
	QXmlStreamReader::TokenType type = xml->readNext();
	Q_ASSERT(type == QXmlStreamReader::StartElement && xml->name()=="value");
	ret = readValue(xml);
	
	type = xml->readNext();
	Q_ASSERT(type == QXmlStreamReader::EndElement);
	
	return ret;
}

QVariant Parser::readValue(QXmlStreamReader* xml)
{
	QXmlStreamReader::TokenType type = xml->readNext();
	Q_ASSERT(type == QXmlStreamReader::StartElement);
	QString valtype = xml->name().toString();
	Q_ASSERT(s_converters.contains(valtype));
	
	QVariant ret = s_converters[valtype](xml);
	type = xml->readNext();
	
	Q_ASSERT(type == QXmlStreamReader::EndElement);
	
	return ret;
}
