#include "widget.h"
#include "settings.h"
#include <QPainter>
#include <QPaintEvent>
#include <QPen>
#include <QBrush>
#include <QProcess>
#include <QToolButton>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QtGui/QX11Info>
#include <QtCore/QByteArray>
#include <QtCore/QCoreApplication>

#include <QtGui/QMessageBox>

QProcess *Proc;
QProcess *Proc2;
QStringList views;
QString datav;
QToolButton *desk1;
QToolButton *desk2;
QToolButton *desk3;
QToolButton *desk4;
QToolButton *desk5;
QToolButton *desk6;
QToolButton *desk7;
QToolButton *desk8;
QToolButton *desk9;


Widget::Widget()
    : QWidget(0, Qt::FramelessWindowHint)
{
    layout = new QGridLayout(this);
    
    desk1 = new QToolButton(this); desk2 = new QToolButton(this); desk3 = new QToolButton(this);
    desk4 = new QToolButton(this); desk5 = new QToolButton(this); desk6 = new QToolButton(this);
    desk7 = new QToolButton(this); desk8 = new QToolButton(this); desk9 = new QToolButton(this);

    desk1->setIconSize(QSize(72,47));
    desk2->setIconSize(QSize(72,47));
    desk3->setIconSize(QSize(72,47));
    desk4->setIconSize(QSize(72,47));
    desk5->setIconSize(QSize(72,47));
    desk6->setIconSize(QSize(72,47));
    desk7->setIconSize(QSize(72,47));
    desk8->setIconSize(QSize(72,47));
    desk9->setIconSize(QSize(72,47));

    desk1->resize(72,47); desk2->resize(72,47); desk3->resize(72,47);
    desk4->resize(72,47); desk5->resize(72,47); desk6->resize(72,47);
    desk7->resize(72,47); desk8->resize(72,47); desk9->resize(72,47);

    layout->setSpacing(0);
    layout->addWidget(desk1,0,0);
    layout->addWidget(desk2,0,1); desk2->setVisible(false);
    layout->addWidget(desk3,0,2); desk3->setVisible(false);
    layout->addWidget(desk4,0,3); desk4->setVisible(false);
    layout->addWidget(desk5,0,4); desk5->setVisible(false);
    layout->addWidget(desk6,0,5); desk6->setVisible(false);
    layout->addWidget(desk7,0,6); desk7->setVisible(false);
    layout->addWidget(desk8,0,7); desk8->setVisible(false);
    layout->addWidget(desk9,0,8); desk9->setVisible(false);

    connect(desk1, SIGNAL( clicked() ), this, SLOT( desktop1() ) );
    connect(desk2, SIGNAL( clicked() ), this, SLOT( desktop2() ) );
    connect(desk3, SIGNAL( clicked() ), this, SLOT( desktop3() ) );
    connect(desk4, SIGNAL( clicked() ), this, SLOT( desktop4() ) );
    connect(desk5, SIGNAL( clicked() ), this, SLOT( desktop5() ) );
    connect(desk6, SIGNAL( clicked() ), this, SLOT( desktop6() ) );
    connect(desk7, SIGNAL( clicked() ), this, SLOT( desktop7() ) );
    connect(desk8, SIGNAL( clicked() ), this, SLOT( desktop8() ) );
    connect(desk9, SIGNAL( clicked() ), this, SLOT( desktop9() ) );


    setContentsMargins(0, 0, 0, 0);
    layout->setContentsMargins(0, 0, 0, 0);
    setLayout(layout);
    setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_OpaquePaintEvent);


    Proc = new QProcess(this);
    connect(Proc, SIGNAL( finished(int) ), this, SLOT( pfinished() ) );
    Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);

}

void Widget::pfinished()
{
    datav = Proc->readAllStandardOutput();
    if ( datav == "" ) return;

    int i = datav.indexOf("[");
    datav.remove(0, i+1);
    i = datav.indexOf("]");
    datav.remove(i, datav.length()-i);

    QString sended = "echo \"Active views = " + datav + "\"";
    QByteArray ba = sended.toLatin1();
    const char *str1 = ba.data();
    system(str1);

    views = datav.split(",");


    if ( views.contains("1") )
    {
        desk1->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-1.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk1->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk1->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
    } else desk1->setVisible(false);

    if ( views.contains("2") )
    {
        desk2->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-2.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk2->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk2->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
    } else desk2->setVisible(false);

    if ( views.contains("3") )
    {
        desk3->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-3.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk3->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk3->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
    } else desk3->setVisible(false);

    if ( views.contains("4") )
    {
        desk4->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-4.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk4->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk4->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
    } else desk4->setVisible(false);

    if ( views.contains("5") )
    {
        desk5->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-5.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk5->setIconSize(QSize(72,47));
        desk5->setIcon( QIcon(QPixmap::fromImage(img)) );
    } else desk5->setVisible(false);

    if ( views.contains("6") )
    {
        desk6->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-6.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk6->setIconSize(QSize(72,47));
        desk6->setIcon( QIcon(QPixmap::fromImage(img)) );
    } else desk6->setVisible(false);

    if ( views.contains("7") )
    {
        desk7->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-7.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk7->setIconSize(QSize(72,47));
        desk7->setIcon( QIcon(QPixmap::fromImage(img)) );
    } else desk7->setVisible(false);

    if ( views.contains("8") )
    {
        desk8->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-8.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk8->setIconSize(QSize(72,47));
        desk8->setIcon( QIcon(QPixmap::fromImage(img)) );
    } else desk8->setVisible(false);

    if ( views.contains("9") )
    {
        desk9->setVisible(true);
        QImage img ( "/home/user/.backgrounds/background-9.png" );
        img = img.scaledToWidth(72,Qt::FastTransformation);
        desk9->setIconSize(QSize(72,47));
        desk9->setIcon( QIcon(QPixmap::fromImage(img)) );
    } else desk9->setVisible(false);

    layout->setContentsMargins(0, 0, 0, 0);

    QCoreApplication::processEvents();

    QWidget::resize(views.count()*72 -1, 47);
    this->resize(views.count()*72 -1, 47);

    //this->setMaximumHeight(47);
    //this->setMaximumWidth(views.count()*72 -1);
    update();

}

void Widget::desktop1()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 1", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}

void Widget::desktop2()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 2", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}

void Widget::desktop3()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 3", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}

void Widget::desktop4()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 4", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}

void Widget::desktop5()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 5", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}

void Widget::desktop6()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 6", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}

void Widget::desktop7()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 7", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}

void Widget::desktop8()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 8", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}

void Widget::desktop9()
{
    Proc2 = new QProcess(this);
    Proc2->start("gconftool-2 -s /apps/osso/hildon-desktop/views/current -t int 9", QProcess::ReadOnly);
    //Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);
}


void Widget::showSettingsDialog()
{
    Settings dlg(0, views);
    dlg.exec();
    Proc->start("gconftool-2 -R /apps/osso/hildon-desktop/views", QProcess::ReadOnly);

}

