#include "settings.h"
#include "ui_settings.h"
#include <QPainter>
#include <QPaintEvent>
#include <QProcess>

QStringList vs;

Settings::Settings(QWidget *parent, QStringList vistas) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);

    vs = vistas;

    checkImage(1);
    checkImage(2);
    checkImage(3);
    checkImage(4);
    checkImage(5);
    checkImage(6);
    checkImage(7);
    checkImage(8);
    checkImage(9);

}

void Settings::checkImage(int boton)
{
    QPixmap base(140,85);
    QPainter p(&base);
    QImage img ( QString("/home/user/.backgrounds/background-%1.png").arg(boton) );
    img = img.scaledToWidth(140,Qt::FastTransformation);
    p.drawPixmap(0, 0, QPixmap::fromImage(img) );

    if ( vs.contains( QString("%1").arg(boton) ) )
        p.drawPixmap(46, 18, QPixmap("/usr/share/icons/hicolor/48x48/hildon/widgets_tickmark_grid.png") );

    p.end();

    if ( boton == 1 ) ui->d1->setIcon( QIcon(base) );
    else if ( boton == 2 ) ui->d2->setIcon( QIcon(base) );
    else if ( boton == 3 ) ui->d3->setIcon( QIcon(base) );
    else if ( boton == 4 ) ui->d4->setIcon( QIcon(base) );
    else if ( boton == 5 ) ui->d5->setIcon( QIcon(base) );
    else if ( boton == 6 ) ui->d6->setIcon( QIcon(base) );
    else if ( boton == 7 ) ui->d7->setIcon( QIcon(base) );
    else if ( boton == 8 ) ui->d8->setIcon( QIcon(base) );
    else if ( boton == 9 ) ui->d9->setIcon( QIcon(base) );

}

Settings::~Settings()
{
    delete ui;
}

void Settings::Aplicar()
{
    vs.sort();
    QString proc = "gconftool -s /apps/osso/hildon-desktop/views/active -t list --list-type int [";

    for ( int i=0; i < vs.count(); ++i )
    {
        proc += QString("%1").arg(vs.at(i));
        proc += ",";
    }

    int j = proc.lastIndexOf(",");
    proc.remove(j,1);
    proc += "]";

    QProcess *Pro = new QProcess(this);

    Pro->start(proc, QProcess::ReadOnly);

}

void Settings::remList(QString valor)
{
    QStringList vs2;
    for ( int i=0; i < vs.count(); ++i )
        if ( vs.at(i) != valor ) vs2.append( vs.at(i) );
    vs = vs2;
}

void Settings::on_d1_clicked()
{
    if ( vs.contains("1") ) remList("1");
    else vs.append("1");
    checkImage(1); Aplicar();
}

void Settings::on_d2_clicked()
{
    if ( vs.contains("2") ) remList("2");
    else vs.append("2");
    checkImage(2); Aplicar();
}

void Settings::on_d3_clicked()
{
    if ( vs.contains("3") ) remList("3");
    else vs.append("3");
    checkImage(3); Aplicar();
}

void Settings::on_d4_clicked()
{
    if ( vs.contains("4") ) remList("4");
    else vs.append("4");
    checkImage(4); Aplicar();
}

void Settings::on_d5_clicked()
{
    if ( vs.contains("5") ) remList("5");
    else vs.append("5");
    checkImage(5); Aplicar();
}

void Settings::on_d6_clicked()
{
    if ( vs.contains("6") ) remList("6");
    else vs.append("6");
    checkImage(6); Aplicar();
}

void Settings::on_d7_clicked()
{
    if ( vs.contains("7") ) remList("7");
    else vs.append("7");
    checkImage(7); Aplicar();
}

void Settings::on_d8_clicked()
{
    if ( vs.contains("8") ) remList("8");
    else vs.append("8");
    checkImage(8); Aplicar();
}

void Settings::on_d9_clicked()
{
    if ( vs.contains("9") ) remList("9");
    else vs.append("9");
    checkImage(9); Aplicar();
}
