import gobject
import gtk
import hildondesktop
import commands
import cairo
import gobject
import pango
import re
import datetime
import sys

supports_alpha = False

class HomeIPPlugin(hildondesktop.HomePluginItem):
    __gtype_name__ = 'HomeIPPlugin'

    def __init__(self):
        hildondesktop.HomePluginItem.__init__(self)

        vbox = gtk.HBox()
        self.icon = gtk.Image()
        self.icon.set_from_stock(gtk.STOCK_NETWORK,gtk.ICON_SIZE_BUTTON)
        vbox.add(self.icon)
        self.label = gtk.Label(self.get_text())
        vbox.add(self.label)
#        self.add(self.label)
        self.add(vbox)

        self.label.set_padding(15, 10)
        self.label.set_size_request(-1,-1)
        self.set_size_request(-1,-1)
        self.inbackground = False

        self.timer = gobject.timeout_add(6000, self.update)

        self.connect("expose-event", self.expose)
        self.connect("screen-changed", self.screen_changed)
        vbox.show_all()

    def expose(self, widget, event):
      cr = self.window.cairo_create()
      if supports_alpha == True:
        cr.set_source_rgba(1.0, 1.0, 1.0, 0.5) # Transparent
      else:
        cr.set_source_rgb(1.0, 1.0, 1.0) # Opaque white

      # Draw the background
      cr.set_operator(cairo.OPERATOR_SOURCE)
      cr.paint()

      # draw rounded rect
      width, height = self.allocation[2], self.allocation[3]

      #/* a custom shape, that could be wrapped in a function */
      x0 = 0   #/*< parameters like cairo_rectangle */
      y0 = 0

      radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */

      x1 = x0 + width
      y1 = y0 + height

      cr.move_to  (x0, y0 + radius)
      cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
      cr.line_to (x1 - radius, y0)
      cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
      cr.line_to (x1 , y1 - radius)
      cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
      cr.line_to (x0 + radius, y1)
      cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)

      cr.close_path ()

      bg_color=gtk.gdk.color_parse('#000000')

      cr.set_source_rgba (bg_color.red / 65535.0, bg_color.green/65535.0, bg_color.blue/65535.0, 0.5)
      cr.fill_preserve ()
      # cr.set_source_rgba (0.5, 0.5, 1.0, 0.8)
      # cr.stroke ()

    def screen_changed(self, widget, old_screen=None):
      global supports_alpha

      # To check if the display supports alpha channels, get the colormap
      screen = widget.get_screen()
      colormap = screen.get_rgba_colormap()
      if colormap == None:
        print 'Your screen does not support alpha channels!'
        colormap = screen.get_rgb_colormap()
        supports_alpha = False
      else:
  #      print 'Your screen supports alpha channels!'
        supports_alpha = True

      # Now we have a colormap appropriate for the screen, use it
      widget.set_colormap(colormap)

      return False

    def update(self):
      self.label.set_text(self.get_text())
      self.label.set_size_request(-1,-1)
      self.set_size_request(-1,-1)
      #self.timer = gobject.timeout_add(2000, self.update)
      return not self.inbackground

    def background(self, widget, data=None):
      #Avoid refresh when applet is in background
      self.label.set_size_request(-1,-1)
      self.set_size_request(-1,-1)
      self.inbackground = True
      if self.timer != None:
        gobject.source_remove(self.timer)
        self.timer = None

    def foreground(self, widget, data=None):  
      self.label.set_text(self.get_text())
      self.label.set_size_request(-1,-1)
      self.set_size_request(-1,-1)
      self.inbackground = False
      self.timer = gobject.timeout_add(6000, self.update)
  #    print "foreground timer", self.timer

    def unrealize(self, widget, date=None):
      # cancel timeout
      v = gobject.source_remove(self.timer)
  #    print "canceled homeip timeout:", v

    def get_text(self):
        text = "Wlan IP: None"
        devs = commands.getoutput("/sbin/ifconfig wlan0")
        sdevs = devs.rsplit('\n')
        for stdev in sdevs:
            #sdev = re.findall("(\S*)\s*", stdev)
            if 'inet addr:' in stdev:
                sdev = stdev.rsplit(':')
                sdev2 = sdev[1].rsplit(' ')
                text= "Wlan IP: " + sdev2[0]

        devs = commands.getoutput("/sbin/ifconfig gprs0")
        sdevs = devs.rsplit('\n')
        for stdev in sdevs:
            #sdev = re.findall("(\S*)\s*", stdev)
            if 'inet addr:' in stdev:
                sdev = stdev.rsplit(':')
                sdev2 = sdev[1].rsplit(' ')
                text=text+"\nPhone IP: " + sdev2[0]
        if 'Phone IP' not in text:
          text=text+"\nPhone IP: None"

        return text

def hd_plugin_get_object():
    return gobject.new(HomeIPPlugin, plugin_id="homeip")

if __name__ == "__main__":
    obj = hd_plugin_get_object()
    obj.show_all()
    print obj.get_text()
    gtk.main()