# -*- coding: utf-8 -*-
# HiveMind - Distributed mind map editor for Maemo 5 platform
# Copyright (C) 2010-2011 HiveMind developers
#
# HiveMind is the legal property of its developers, whose names are
# noticed in  or  annotations at the beginning of each
# module or class.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111-1301  USA

'''
Error messages for network subsystem
'''

from PyQt4.QtCore import QObject
from hivemind.attribute import readable


class StanzaErrorMessages(QObject):
    '''
    Map stanza errors to text messages according to RFC 3920
    @author: Oleg Kandaurov
    '''
    readable('condition')
    def __init__(self):
        QObject.__init__(self)
        self.__condition = {
        'bad-request': self.tr('The sender has sent XML that is malformed or ' +
                'that cannot be processed.'),

        'conflict': self.tr('Access cannot be granted because an existing resource ' +
                'or session exists with the same name or address.'),

        'feature-not-implemented': self.tr('The feature requested is not implemented by the ' +
                'recipient or server and therefore cannot be processed.'),

        'forbidden': self.tr('The requesting entity does not possess the required ' +
        'permissions to perform the action.'),

        'gone': self.tr('The recipient or server can no longer be contacted at this address.'),

        'internal-server-error': self.tr('The server could not process the stanza because ' +
        'of a misconfiguration or an otherwise-undefined internal server error.'),

        'item-not-found': self.tr('The addressed JID or item requested cannot be found.'),

        'jid-malformed': self.tr('The sending entity has provided or communicated an XMPP ' +
        'address or aspect thereof that does not adhere to the syntax defined in ' +
        'Addressing Scheme.'),

        'not-acceptable': self.tr('The recipient or server understands the request but ' +
        'is refusing to process it because it does not meet criteria defined by the ' +
        'recipient or server.'),

        'not-allowed': self.tr('The recipient or server does not allow any entity to ' +
        'perform the action.'),

        'not-authorized': self.tr('The sender must provide proper credentials before being ' +
        'allowed to perform the action, or has provided improper credentials.'),

        'payment-required': self.tr('The requesting entity is not authorized to access ' +
        'the requested service because payment is required.'),

        'recipient-unavailable': self.tr('The intended recipient is temporarily unavailable.'),

        'redirect': self.tr('The recipient or server is redirecting requests for this ' +
        'information to another entity, usually temporarily.'),

        'registration-required': self.tr('The requesting entity is not authorized to ' +
        'access the requested service because registration is required.'),

        'remote-server-not-found': self.tr('A remote server or service specified as part or ' +
        'all of the JID of the intended recipient does not exist.'),

        'remote-server-timeout': self.tr('A remote server or service specified as part or ' +
         'all of the JID of the intended recipient could not be contacted within a ' +
         'reasonable amount of time.'),

        'resource-constraint': self.tr('The server or recipient lacks the system resources ' +
        'necessary to service the request.'),

        'service-unavailable': self.tr('The server or recipient does not currently provide ' +
        'the requested service.'),

        'subscription-required': self.tr('The requesting entity is not authorized to access ' +
        'the requested service because a subscription is required.'),

        'undefined-condition': self.tr('The error condition is not one of those defined by ' +
        'the other conditions in this list'),

        'unexpected-request': self.tr('The recipient or server understood the request but ' +
        'was not expecting it at this time.')}


class StreamErrorMessages(QObject):
    '''
    Map stream errors to text messages according to RFC 3920
    @author: Oleg Kandaurov
    '''
    readable('condition')
    def __init__(self):
        QObject.__init__(self)
        self.__condition = {
        'bad-format': self.tr('The entity has sent XML that cannot be processed.'),

        'bad-namespace-prefix': self.tr('The entity has sent a namespace prefix that is ' +
        'unsupported, or has sent no namespace prefix on an element that requires ' +
        'such a prefix.'),

        'conflict': self.tr('The server is closing the active stream for this entity ' +
        'because a new stream has been initiated that conflicts with the existing stream.'),

        'connection-timeout': self.tr('The entity has not generated any traffic over the ' +
        'stream for some period of time.'),

        'host-gone': self.tr('The value of the "to" attribute provided by the initiating ' +
        'entity in the stream header corresponds to a hostname that is no longer hosted by ' +
        'the server.'),

        'host-unknown': self.tr('The value of the "to" attribute provided by the initiating ' +
        'entity in the stream header does not correspond to a hostname that is hosted by ' +
        'the server.'),

        'improper-addressing': self.tr('A stanza sent between two servers lacks a "to" or ' +
        '"from" attribute.'),

        'internal-server-error': self.tr('The server has experienced a misconfiguration or ' +
        'an otherwise-undefined internal error that prevents it from servicing the stream.'),

        'invalid-from': self.tr('The JID or hostname provided in a "from" address does not ' +
        'match an authorized JID or validated domain negotiated between servers via SASL or ' +
        'dialback, or between a client and a server via authentication and resource binding.'),

        'invalid-id': self.tr('The stream ID or dialback ID is invalid or does not match an ' +
        'ID previously provided.'),

        'invalid-namespace': self.tr('The streams namespace name is something other than ' +
        '"http://etherx.jabber.org/streams" or the dialback namespace name is something ' +
        'other than "jabber:server:dialback".'),

        'invalid-xml': self.tr('The entity has sent invalid XML over the stream to a ' +
        'server that performs validation.'),

        'not-authorized': self.tr('The entity has attempted to send data before the stream ' +
        'has been authenticated, or otherwise is not authorized to perform an action ' +
        'related to stream negotiation.'),

        'policy-violation': self.tr('The entity has violated some local service policy.'),

        'remote-connection-failed': self.tr('The server is unable to properly connect to a ' +
        'remote entity that is required for authentication or authorization.'),

        'resource-constraint': self.tr('The server lacks the system resources necessary to ' +
        'service the stream.'),

        'restricted-xml': self.tr('The entity has attempted to send restricted XML features ' +
        'such as a comment, processing instruction, DTD, entity reference, or unescaped ' +
        'character.'),

        'see-other-host': self.tr('The server will not provide service to the initiating ' +
        'entity but is redirecting traffic to another host.'),

        'system-shutdown': self.tr('The server is being shut down and all active streams ' +
        'are being closed.'),

        'undefined-condition': self.tr('The error condition is not one of those defined by ' +
        'the other conditions in this list.'),

        'unsupported-encoding': self.tr('The initiating entity has encoded the stream in an ' +
        'encoding that is not supported by the server.'),

        'unsupported-stanza-type': self.tr('The initiating entity has sent a first-level ' +
        'child of the stream that is not supported by the server.'),

        'unsupported-version': self.tr('The value of the "version" attribute provided by ' +
        'the initiating entity in the stream header specifies a version of XMPP that is not ' +
        'supported by the server.'),

        'xml-not-well-formed': self.tr('The initiating entity has sent XML that is not ' +
        'well-formed as defined by XML.')}


class SASLErrorMessages(QObject):
    '''
    Map SASL errors to text messages according to RFC 3920
    @author: Oleg Kandaurov
    '''
    readable('condition')
    def __init__(self):
        QObject.__init__(self)
        self.__condition = {
        'aborted': self.tr('The receiving entity acknowledges an <abort/> element sent by ' +
        'the initiating entity.'),

        'incorrect-encoding': self.tr('The data provided by the initiating entity could not ' +
        'be processed because the BASE64 encoding is incorrect.'),

        'invalid-authzid': self.tr('The authzid provided by the initiating entity is ' +
        'invalid, either because it is incorrectly formatted or because the initiating ' +
        'entity does not have permissions to authorize that ID.'),

        'invalid-mechanism': self.tr('The initiating entity did not provide a mechanism or ' +
        'requested a mechanism that is not supported by the receiving entity.'),

        'mechanism-too-weak': self.tr('The mechanism requested by the initiating entity is ' +
        'weaker than server policy permits for that initiating entity.'),

        'not-authorized': self.tr('The authentication failed because the initiating entity ' +
        'did not provide valid credentials.'),

        'temporary-auth-failure': self.tr('The authentication failed because of a temporary ' +
        'error condition within the receiving entity.')}


class PubSubErrorMessages(QObject):
    '''
    Map PubSub errors to text messages according to XEP-0060
    @author: Oleg Kandaurov
    '''
    readable('condition', 'feature')
    def __init__(self):
        QObject.__init__(self)
        self.__condition = {
        'item-forbidden': self.tr('Item forbidden'),
        'item-required': self.tr('Item required'),
        'nodeid-required': self.tr('Node id required'),
        'jid-required': self.tr('JID required'),
        'unsupported': self.tr('Unsupported'),
        'not-subscribed': self.tr('Not subscribed'),
        'closed-node': self.tr('Closed node'),
        'not-in-roster-group': self.tr('Not in roster group'),
        # Unused error messages
        'invalid-jid': self.tr('invalid-jid'),
        'presence-subscription-required': self.tr('presence-subscription-required'),
        'pending-subscription': self.tr(''),
        'too-many-subscriptions': self.tr('pending-subscription'),
        'configuration-required': self.tr('configuration-required'),
        'subid-required': self.tr('subid-required'),
        'invalid-subid': self.tr('invalid-subid'),
        'payload-too-big': self.tr('payload-too-big'),
        'payload-required': self.tr('payload-required'),
        'unsupported-access-model': self.tr('unsupported-access-model'), }

        self.__feature = {
        'create-nodes': self.tr('Creation of nodes'),
        'config-node': self.tr('Configuration of node options'),
        'purge-nodes': self.tr('Purging of nodes'),
        'delete-nodes': self.tr('Deletion of nodes'),
        'publish': self.tr('Publishing items'),
        'subscribe': self.tr('Subscribing and unsubscribing'),
        'retrieve-subscriptions': self.tr('Retrieval of current subscriptions'),
        'retrieve-affiliations': self.tr('Retrieval of current affiliations'),
        'retrieve-default': self.tr('Retrieval of default node configuration'),
        'retrieve-items': self.tr('Item retrieval'),
        'retract-items': self.tr('Item retraction'),
        'modify-affiliations': self.tr('Modifying affiliations'),
        'manage-subscriptions': self.tr('Managing subscriptions'),
        'collections': self.tr('Collection nodes'),
        'item-ids': self.tr('Specifying item identifiers'),
        'meta-data': self.tr('Node meta-data'),
        'instant-nodes': self.tr('Creation of instant nodes'),
        'outcast-affiliation': self.tr('The outcast affiliation'),
        'persistent-items': self.tr('Persistent items'),
        'publisher-affiliation': self.tr('The publisher affiliation')}

