# -*- coding: utf-8 -*-
# HiveMind - Distributed mind map editor for Maemo 5 platform
# Copyright (C) 2011 HiveMind developers
#
# HiveMind is the legal property of its developers, whose names are
# noticed in  or  annotations at the beginning of each
# module or class.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111-1301  USA

'''
Module contains special robots for filling mind map with external data in
'''

class SmartConferenceRobot(object):
    '''
    Creates specialized data from the smart conference system. This robot may work for a long
    time.

    @author: Andrew Vasilev
    '''
    def __init__(self, mindMapDelegate):
        ''''''
        self.__connection = None
        self.__mindMapDelegate = mindMapDelegate

    def start(self):
        '''Begin data collection from the smart space'''
        try:
            from hivemind.smartconference.kp import SmartSpace
        except:
            raise Exception('Smart M3 python support is not installed')
        try:
            self.__connection = SmartSpace('X', '127.0.0.1', 10010)
        except:
            raise Exception('Unable to connect to the smart space')

    def stop(self):
        '''Stop data collection from the smart space'''
        if self.__connection:
            self.__connection.close()
        self.__connection = None
