# -*- coding: utf-8 -*-
# HiveMind - Distributed mind map editor for Maemo 5 platform
# Copyright (C) 2010 HiveMind developers
#
# HiveMind is the legal property of its developers, whose names are
# noticed in @author or @authors annotations at the beginning of each
# module or class.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111-1301  USA

'''
Main window class for Mobile platform
'''

from hivemind.main_window import *

class MaemoMainWindow(AbstractMainWindow):
    '''
    Main window of HiveMind program for Maemo platform

    @author: Alexander Kulikov
    '''
    def __init__(self, controller, mindMapScene):
        '''Create new window'''
        AbstractMainWindow.__init__(self, controller, mindMapScene)
        FullScreenExitButton(self)
        self.__fullScreenAction = QAction(QIcon.fromTheme('view-fullscreen'),
                self.tr('&Full screen'), self)
        self.__fullScreenAction.connect(SIGNAL('triggered()'), self.showFullScreen)
        self._createContextMenu(controller)
        self._createMainMenu(controller)
        self._createZoomWidget(controller)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

    def _createZoomWidget(self, controller):
        self.__zoomWidget = MaemoZoomWidget(self._mindMapView, controller.zoomInAction,
                controller.zoomOutAction)


    def _createContextMenu(self, controller):
        self.__menu = MaemoNodeMenu(self._mindMapView, controller)
        self.__additionalMenu = MaemoNodeMenu(self._mindMapView, controller)
        self.__menu.addAction(controller.addNodeAction, 'add_node')
        self.__menu.addAction(controller.removeNodeAction, 'remove_node')
        self.__menu.addAction(controller.editNodeAction, 'edit_node')
        controller.foldNodeAction.setCheckable(True)
        self.__menu.addAction(controller.foldNodeAction, 'hide_subtree')
        self.__additionalMenu.addAction(controller.editNodeIconsAction, 'edit_icons')
        self.__additionalMenu.addAction(controller.editEdgeAction, 'edit_edge')
        self.__additionalMenu.addAction(controller.moveNodeAction, 'move_node')
        self.__additionalMenu.addAction(controller.editLabelAction, 'label_edge')
        self.connect(self.__menu, SIGNAL('show'),
                     adaptCallable(self.__additionalMenu.hideMenu))
        self.connect(self.__additionalMenu, SIGNAL('show'),
                     adaptCallable(self.__menu.hideMenu))

    def _createMainMenu(self, controller):
        '''
        Create main menu
        @type controller: MainWindowController
        '''
        menu = self.menuBar().addMenu('')
        menu.addAction(controller.fileNewAction)
        menu.addAction(controller.fileOpenAction)
        menu.addAction(controller.fileSaveAction)
        menu.addAction(controller.fileSaveAsAction)
        menu.addAction(self.__fullScreenAction)
        menu.addAction(controller.aboutAction)
        menu.addAction(controller.settingsAction)
        menu.addAction(controller.undoAction)
        menu.addAction(controller.redoAction)
        menu.addAction(controller.startNetworkServerAction)
        menu.addAction(controller.startNetworkClientAction)
        menu.addAction(controller.stopNetworkAction)

    def showMenu(self, rightButton, item):
        '''Show one of the two menus according to the button clicked'''
        menu = self.__additionalMenu if rightButton else self.__menu
        menu.show(item)
