# -*- coding: utf-8 -*-
# HiveMind - Distributed mind map editor for Maemo 5 platform
# Copyright (C) 2010-2011 HiveMind developers
#
# HiveMind is the legal property of its developers, whose names are
# noticed in  or  annotations at the beginning of each
# module or class.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111-1301  USA

'''
Directory configuration module.

Its content is for development purposes only.
setup.py will overwrite it and set its variables according to application
configuration.

@author: Ilya Paramonov
'''

import os

BASEDIR = os.path.dirname(os.path.dirname(__file__))
'''
Base directory of application.

It is calculated as a parent directory of the one where this .py/.pyc
file is located. Normally it is /usr/share/hivemind.
 
Resources are stored in subdirectories of the base directory 
(for instance: config, images etc.)
'''

TRANSLATION_PATH_TEMPLATE = BASEDIR + '/translations/%s'
'''
Template for constructing of full path of translation
'''
