# -*- coding: utf-8 -*-
# HiveMind - Distributed mind map editor for Maemo 5 platform
# Copyright (C) 2010 HiveMind developers
#
# HiveMind is the legal property of its developers, whose names are
# noticed in  or  annotations at the beginning of each
# module or class.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111-1301  USA

'''
Application resource manager

@author: Alexander Kulikov 
'''

import os
import hivemind.settings as settings
import hivemind.__dirs__ as __dirs__
from PySide.QtGui import *

__ICONS = {}
'''Hash table containing icons'''

def getIconByName(name):
    '''
    Get the image with the given name.
    If the name is not present, supply None instead

    @rtype: QImage
    '''
    if __ICONS.has_key(name):
        return __ICONS[name]
    return None

def getImage(name):
    '''
    @param name: name of image file without extension

    @return: new image object on first call, cached image afterwards 
    @rtype: QPixmap
    '''
    fullname = os.path.join(__dirs__.BASEDIR, 'images', name + '.png')
    image = QPixmap()
    if not QPixmapCache.find(fullname, image):
        image = QPixmap(fullname)
        QPixmapCache.insert(fullname, image)
    return image

def _loadIcons():
    '''
    Load icons to the hash table using a list of
    names of icons from the configuration file
    '''
    path = os.path.join(__dirs__.BASEDIR, 'icons')
    for name in settings.get("listIcons"):
        fullPath = os.path.join(path, name + '.png')
        image = QImage(fullPath)
        if image:
            __ICONS[name] = image

# Initialization
_loadIcons()
