# -*- coding: utf-8 -*-
# HiveMind - Distributed mind map editor for Maemo 5 platform
# Copyright (C) 2010 HiveMind developers
#
# HiveMind is the legal property of its developers, whose names are
# noticed in @author or @authors annotations at the beginning of each
# module or class.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111-1301  USA

'''
GUI factories

@author: Alexander Kulikov
'''

from hivemind.desktop.main_window import *
from hivemind.maemo.main_window import *
from hivemind.desktop.dialogs import *
from hivemind.maemo.dialogs import *

__MAEMO = True
'''True if the application is run on Maemo platform'''

try:
    from PySide.QtMaemo5 import *
except ImportError:
    __MAEMO = None

def createMainWindow(controller, mindMapScene):
    '''
    Factory for creating families of related main windows
    @type controller: MainWindowController
    @type mindMapScene: MindMapDelegate
    '''
    if __MAEMO: return MaemoMainWindow(controller, mindMapScene)
    return DesktopMainWindow(controller, mindMapScene)

def createEditNodeDialog(node, parent):
    '''
    Factory for creating families of related node editing dialogs
    @type node: Node
    @type parent: QWidget
    '''
    if __MAEMO:
        return MaemoEditNodeDialog(node, parent)
    return DesktopEditNodeDialog(node, parent)

def createEditEdgeDialog(node, parent):
    '''
    Factory for creating families of related edge editing dialogs
    @type node: Node
    @type parent: QWidget
    '''
    if __MAEMO:
        return MaemoEditEdgeDialog(node, parent)
    return DesktopEditEdgeDialog(node, parent)

def createIconDialog(node, parent):
    '''
    Factory for creating families of related icon dialogs
    @type node: Node
    @type parent: QWidget
    '''
    if __MAEMO:
        return MaemoIconDialog(node, parent)
    return DesktopIconDialog(node, parent)

def createAboutDialog(parent):
    '''
    Factory for creating families of related about dialogs
    @type parent: QWidget
    '''
    if __MAEMO:
        return MaemoAboutDialog(parent)
    return DesktopAboutDialog(parent)

def createSettingsDialog(parent):
    '''
    Factory for creating families of related settings dialogs
    @type parent: QWidget
    '''
    if __MAEMO:
        return MaemoSettingsDialog(parent)
    return DesktopSettingsDialog(parent)

def createEditLabelDialog(node, parent):
    '''
    Factory for creating families of related edge label editing dialogs
    @type node: Node
    @type parent: QWidget
    '''
    if __MAEMO:
        return MaemoEditLabelDialog(node, parent)
    return DesktopEditLabelDialog(node, parent)

def createXMPPCredentialsDialog(client, parent):
    '''
    Factory for creating families of related xmpp credentials dialogs
    @type parent: QWidget
    '''
    if __MAEMO:
        return MaemoXMPPCredentialsDialog(client, parent)
    return DesktopXMPPCredentialsDialog(client, parent)

def createSideSelectionDialog(parent):
    '''
    Factory for creating families of related side selection dialogs
    @type parent: QWidget
    '''
    return SideSelectionDialog(parent)
