<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
Copyright (c) 2009 Openismus GmbH

XSL transformation from a Doxygen tag file to plain text format.

This script is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation, either version 2 of the License,
or (at your option) any later version.

This script is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this script.  If not, see <http://www.gnu.org/licenses/>.
-->

<xsl:output format="xml" version="1.0" indent="yes" encoding="UTF-8"/>

<!-- Label for first table of contents entry. -->
<xsl:param name="toc-label"/>
<!-- "link_to" attribute for toplevel "toc" element.  -->
<xsl:param name="toc-link"/>
<!-- Base path for documentation, prepended to all links. Must end with "/". -->
<xsl:param name="base-path"/>

<xsl:template match="/">
  <?NLS TYPE="org.eclipse.help.toc"?>
  <toc label="{$toc-label}" link_to="{$toc-link}">
    <topic label="Modules" href="{$base-path}modules.html">
      <xsl:apply-templates select="tagfile/compound[@kind='group']" mode="topics"/>
    </topic>
    <topic label="File List" href="{$base-path}files.html">
      <xsl:apply-templates select="tagfile/compound[@kind='file']" mode="files"/>
    </topic>
    <topic label="Namespaces" href="{$base-path}namespaces.html">
      <xsl:apply-templates select="tagfile/compound[@kind='namespace']" mode="topics"/>
    </topic>
    <topic label="Class Hierarchy" href="{$base-path}classes.html">
      <xsl:apply-templates select="tagfile/compound[@kind='class' or @kind='struct']" mode="topics"/>
    </topic>
  </toc>
</xsl:template>

<!-- File compounds need ".html" appended to the filename -->
<xsl:template match="compound" mode="files">
  <topic label="{name}" href="{$base-path}{filename}.html"/>
</xsl:template>

<!-- Group, class and struct compounds do not need ".html" appended to the filename -->
<xsl:template match="compound" mode="topics">
  <topic label="{name}" href="{$base-path}{filename}"/>
</xsl:template>

</xsl:stylesheet>
