// -*- c++ -*-
/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/touch-selector-text.h>
#include <gtkmm/cellrenderertext.h>
#include <hildon/hildon.h>

namespace Hildon
{

TouchSelectorText::TouchSelectorText()
{
  m_model = Gtk::ListStore::create(m_text_columns);
  append_text_column(m_model, m_text_columns.m_column);
}

TouchSelectorText::TouchSelectorText(HildonTouchSelector* castitem)
: TouchSelector(castitem)
{
  m_model = Gtk::ListStore::create(m_text_columns);
  append_text_column(m_model, m_text_columns.m_column);
}


void TouchSelectorText::append_text(const Glib::ustring& text)
{
  //We cannot use hildon_touch_selector_append_text() here, because that can only be used if hildon_touch_selector_new_text() has been used.

  if(m_model)
  {
    Gtk::TreeModel::iterator iter = m_model->append();
    Gtk::TreeModel::Row row = *iter;
    row[m_text_columns.m_column] = text;
  }
}

void TouchSelectorText::insert_text(int position, const Glib::ustring& text)
{
  //TODO: We should not use hildon_touch_selector_insert_text() here, because that can only be used if hildon_touch_selector_new_text() has been used.
  hildon_touch_selector_insert_text(gobj(), position, text.c_str());
}

void TouchSelectorText::prepend_text(const Glib::ustring& text)
{
  //We cannot use hildon_touch_selector_prepend_text() here, because that can only be used if hildon_touch_selector_new_text() has been used.

  if(m_model)
  {
    Gtk::TreeModel::iterator iter = m_model->prepend();
    Gtk::TreeModel::Row row = *iter;
    row[m_text_columns.m_column] = text;
  }
}

Glib::ustring TouchSelectorText::get_selected_text() const
{
  // We cannot use gtk_combobox_get_active_text() here, because that can only be used if hildon_touch_selector_new_text() has been used.

  Glib::ustring result;

  //Get the selected row:
  Gtk::TreeModel::iterator selected_row =
    const_cast<Hildon::TouchSelectorText&>(*this).get_selected();
  if(selected_row)
  {
    Gtk::TreeModel::Row row = *selected_row;
    result = row[m_text_columns.m_column];
  }

  return result;
}

//deprecated.
void TouchSelectorText::clear()
{
  clear_items();
}

void TouchSelectorText::clear_items()
{
  if(m_model)  
    m_model->clear();
}

void TouchSelectorText::remove_text(const Glib::ustring& text)
{
  //Look for the row with this text, and remove it:
  if(m_model)
  {
    for(Gtk::TreeModel::iterator iter = m_model->children().begin(); iter != m_model->children().end(); ++iter)
    {
      const Glib::ustring& this_text = (*iter)[m_text_columns.m_column];

      if(this_text == text)
      {
        m_model->erase(iter);
        return; //success
      }
    }
  }
}

void TouchSelectorText::set_selected_text(const Glib::ustring& text)
{
  //Look for the row with this text, and activate it:
  Glib::RefPtr<Gtk::TreeModel> model = get_model(0);
  if(model)
  {
    for(Gtk::TreeModel::iterator iter = model->children().begin(); iter != model->children().end(); ++iter)
    {
      const Glib::ustring& this_text = (*iter)[m_text_columns.m_column];

      if(this_text == text)
      {
        set_selected(0, iter);
        return; //success
      }
    }
  }

  //Not found, so mark it as blank:
  unselect_all(0);
}


} // namespace Hildon


