// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_TEXT_VIEW_H
#define _HILDONMM_TEXT_VIEW_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/textview.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonTextView HildonTextView;
typedef struct _HildonTextViewClass HildonTextViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class TextView_Class; } // namespace Hildon
namespace Hildon
{

/** A text view widget, derived from Gtk::TextView, with additional features specific
 * to the Hildon framework.
 *
 * Besides all the features inherited from Gtk::TextView, a Hildon::TextView
 * can also have a placeholder text. This text will be shown if the text view
 * is empty and doesn't have the input focus, but it's otherwise ignored. Thus,
 * calls to Hildon::TextView::get_buffer() will never return the placeholder
 * text, not even when it's being displayed.
 *
 * Although Hildon::TextView is derived from Gtk::TextView,
 * Gtk::TextView::get_buffer() and Gtk::TextView::set_buffer() must never be
 * used to get/set the buffer in this widget. Hildon::TextView::get_buffer()
 * and Hildon::TextView::set_buffer() must be used instead.
 *
 * @ingroup HildonWidgets
 */

class TextView : public Gtk::TextView
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TextView CppObjectType;
  typedef TextView_Class CppClassType;
  typedef HildonTextView BaseObjectType;
  typedef HildonTextViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TextView();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TextView_Class;
  static CppClassType textview_class_;

  // noncopyable
  TextView(const TextView&);
  TextView& operator=(const TextView&);

protected:
  explicit TextView(const Glib::ConstructParams& construct_params);
  explicit TextView(HildonTextView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonTextView*       gobj()       { return reinterpret_cast<HildonTextView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonTextView* gobj() const { return reinterpret_cast<HildonTextView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  TextView();

  
  /** Sets @a buffer as the buffer being displayed by @a text_view. The
   * previous buffer displayed by the text view is unreferenced, and a
   * reference is added to @a buffer. If you owned a reference to @a buffer
   * before passing it to this function, you must remove that reference
   * yourself
   * 
   * @newin{2,2}
   * 
   * Deprecated: use gtk_text_view_set_buffer() instead
   * @param buffer A Gtk::TextBuffer.
   */
  void set_buffer(const Glib::RefPtr<Gtk::TextBuffer>& buffer);
  
  /** Returns: a Gtk::TextBuffer
   * @return A Gtk::TextBuffer
   * 
   * @newin{2,2}
   * 
   * Deprecated: use gtk_text_view_get_buffer() instead.
   */
  Glib::RefPtr<Gtk::TextBuffer> get_buffer();
  
  /** Returns: a Gtk::TextBuffer
   * @return A Gtk::TextBuffer
   * 
   * @newin{2,2}
   * 
   * Deprecated: use gtk_text_view_get_buffer() instead.
   */
  Glib::RefPtr<const Gtk::TextBuffer> get_buffer() const;

  
  /** Sets the placeholder text in @a text_view to @a text.
   * 
   * @newin{2,2}
   * 
   * Deprecated: use hildon_gtk_text_view_set_placeholder_text() instead
   * @param text The new text.
   */
  void set_placeholder(const Glib::ustring& text);


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::TextView
   */
  Hildon::TextView* wrap(HildonTextView* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_TEXT_VIEW_H */

