// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_PROGRAM_H
#define _HILDONMM_PROGRAM_H


#include <glibmm.h>

/*
 * Copyright (c) 2005-2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/app-menu.h>
#include <hildonmm/window.h>
#include <gtkmm/menu.h>
#include <gtkmm/toolbar.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonProgram HildonProgram;
typedef struct _HildonProgramClass HildonProgramClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Program_Class; } // namespace Hildon
namespace Hildon
{

/** A Hildon::Program is the base of any Hildon application. 
 * It represents an application running in the Hildon framework. 
 * The Hildon::Program tracks the top-most status of an application and informs 
 * the task navigator when the application can be hibernated. 
 *
 * It also provides tools to get and set menus and toolbars which are common for 
 * all application windows.
 *
 * The Hildon::Program object is created by calling the static get_instance() method, which takes 
 * no parameters and returns a new Hildon::Program. 
 *
 * The following methods are of particular interest:
 * - add_window() add a Hildon::Window to the Program.
 * - set_can_hibernate() informs the task navigator that it can hibernate the HildonProgram.
 * - set_common_app_menu() sets the common menu for all application windows.
 * - set_common_toolbar() sets the common toolbar for all application windows.
 *
 * @section Menus
 *
 * A Hildon::AppMenu can be created and attached to the Hildon::Program 
 * to be used as a common menu for all Hildon::Windows that do not have their own menu. 
 * Another way is to use a Hildon::AppMenuu in a Hildon::Window. In this way, every application window can have a different 
 * menu.
 *
 * @section Toolbars
 *
 * To create an application that has a toolbar, create a normal Hildon::Window and a normal Gtk::Toolbar. 
 * The toolbar is used like any Gtk::Toolbar and it can contain normal Gtk::ToolItems, such as ToolButton, ToggleToolButton, etc.
 *
 * The main difference in maemo compared to normal GTK+/gtkmm usage is that toolbars can be common to all Hildon::Windows in an 
 * application or they can be used only in a particular HildonWindow.
 *
 * @see Hildon::EditToolbar.
 */

class Program : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Program CppObjectType;
  typedef Program_Class CppClassType;
  typedef HildonProgram BaseObjectType;
  typedef HildonProgramClass BaseClassType;

private:  friend class Program_Class;
  static CppClassType program_class_;

private:
  // noncopyable
  Program(const Program&);
  Program& operator=(const Program&);

protected:
  explicit Program(const Glib::ConstructParams& construct_params);
  explicit Program(HildonProgram* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Program();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  HildonProgram*       gobj()       { return reinterpret_cast<HildonProgram*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const HildonProgram* gobj() const { return reinterpret_cast<HildonProgram*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  HildonProgram* gobj_copy();

private:

   
public:
  
  /** Return value: the Hildon::Program.
   * @return The Hildon::Program.
   */
  static Glib::RefPtr<Program> get_instance();

  
  /** Registers a Hildon::Window as belonging to a given Hildon::Program. This
   * allows to apply program-wide settings as all the registered windows,
   * such as set_common_menu(), set_common_app_menu()
   * and set_common_toolbar().
   * @param window A Hildon::Window to be added.
   */
  void add_window(Window& window);
  
  /** Used to unregister a window from the program. Subsequent calls to
   * set_common_menu(), set_common_app_menu()
   * and set_common_toolbar() will not affect the window.
   * @param window The Hildon::Window to unregister.
   */
  void remove_window(Window& window);

  
  /** Used to set whether or not the Hildon task navigator should
   * be able to set the program to hibernation in case of low memory
   * @param can_hibernate Whether or not the Hildon::Program can hibernate.
   */
  void set_can_hibernate(bool can_hibernate = true);
  
  /** Return value: <tt>true</tt> if the program can hibernate, <tt>false</tt> otherwise.
   * @return <tt>true</tt> if the program can hibernate, <tt>false</tt> otherwise.
   */
  bool get_can_hibernate() const;

  
  /** Sets a Gtk::Menu that will appear in all Hildon::Window<!-- -->s
   * registered with the Hildon::Program. Only one common Gtk::Menu can be
   * set, further calls will detach the previous common Gtk::Menu. A
   * Hildon::Window can use its own Gtk::Menu with
   * Hildon::Window::set_menu()
   * 
   * This method does not support Hildon::AppMenu<!-- -->s. See
   * set_common_app_menu() for that.
   * @param menu A Gtk::Menu to use as common menu for the program.
   */
  void set_common_menu(Gtk::Menu& menu);
  
  /** Return value: the Gtk::Menu or <tt>0</tt> of no common menu was set.
   * @return The Gtk::Menu or <tt>0</tt> of no common menu was set.
   */
  Gtk::Menu* get_common_menu();
  
  /** Return value: the Gtk::Menu or <tt>0</tt> of no common menu was set.
   * @return The Gtk::Menu or <tt>0</tt> of no common menu was set.
   */
  const Gtk::Menu* get_common_menu() const;

  
  /** Sets a Hildon::AppMenu that will appear in all
   * Hildon::Window<!-- -->s registered with the Hildon::Program. Only
   * one common Hildon::AppMenu can be set, further calls will detach the
   * previous common Hildon::AppMenu. A Hildon::Window can use its own
   * Hildon::AppMenu with Hildon::Window::set_app_menu()
   * 
   * This method does not support Gtk::Menu<!-- -->s. See
   * set_common_menu() for that.
   * 
   * @newin{2,2}
   * @param menu A Hildon::AppMenu to use as common menu for the program.
   */
  void set_common_app_menu(AppMenu& menu);
  
  /** Return value: the Hildon::AppMenu or <tt>0</tt> of no common app menu was
   * @return The Hildon::AppMenu or <tt>0</tt> of no common app menu was
   * set.
   * 
   * @newin{2,2}.
   */
  AppMenu* get_common_app_menu();
  
  /** Return value: the Hildon::AppMenu or <tt>0</tt> of no common app menu was
   * @return The Hildon::AppMenu or <tt>0</tt> of no common app menu was
   * set.
   * 
   * @newin{2,2}.
   */
  const AppMenu* get_common_app_menu() const;

  
  /** Sets a Gtk::Toolbar that will appear in all the Hildon::Window registered
   * to the Hildon::Program. Only one common Gtk::Toolbar can be set, further
   * call will detach the previous common Gtk::Toolbar. A Hildon::Window
   * can use its own Gtk::Toolbar with Hildon::Window::add_toolbar(). Both
   * Hildon::Program and Hildon::Window specific toolbars will be shown
   * @param toolbar A Gtk::Toolbar to use as common toolbar for the program.
   */
  void set_common_toolbar(Gtk::Toolbar& toolbar);
  
  /** Return value: the Gtk::Toolbar or <tt>0</tt> of no common toolbar was
   * @return The Gtk::Toolbar or <tt>0</tt> of no common toolbar was
   * set.
   */
  Gtk::Toolbar* get_common_toolbar();
  
  /** Return value: the Gtk::Toolbar or <tt>0</tt> of no common toolbar was
   * @return The Gtk::Toolbar or <tt>0</tt> of no common toolbar was
   * set.
   */
  const Gtk::Toolbar* get_common_toolbar() const;

  
  /** Return value: <tt>true</tt> if a window or dialog is topmost, <tt>false</tt>
   * @return <tt>true</tt> if a window or dialog is topmost, <tt>false</tt>
   * otherwise.
   */
  bool get_is_topmost() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether one of the program's window or dialog currently is activated by window manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_topmost() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the program should be set to hibernate by the Task Navigator in low memory situation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_can_hibernate() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the program should be set to hibernate by the Task Navigator in low memory situation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_hibernate() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::Program
   */
  Glib::RefPtr<Hildon::Program> wrap(HildonProgram* object, bool take_copy = false);
}


#endif /* _HILDONMM_PROGRAM_H */

