<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
Copyright (c) 2009 Openismus GmbH

XSL transformation from a Doxygen tag file to plain text format.

This script is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation, either version 2 of the License,
or (at your option) any later version.

This script is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this script.  If not, see <http://www.gnu.org/licenses/>.
-->

<xsl:output method="text" encoding="UTF-8"/>

<!-- Base path for documentation, prepended to all links. Must end with "/" -->
<xsl:param name="base-path"/>

<xsl:template match="/">
  <xsl:text># hildonmm API reference
</xsl:text>
  <xsl:apply-templates select="tagfile/compound" mode="compound">
    <xsl:sort lang="en" case-order="upper-first" select="name"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="compound[@kind='namespace']" mode="compound">
  <xsl:apply-templates select="member" mode="symbol">
    <xsl:sort lang="en" case-order="upper-first" select="name"/>
  </xsl:apply-templates>
</xsl:template>
<xsl:template match="compound[@kind='class' or @kind='struct']" mode="compound">
  <xsl:apply-templates select="member" mode="symbol">
    <xsl:sort lang="en" case-order="upper-first" select="name"/>
  </xsl:apply-templates>
</xsl:template>
<!-- Ignore compounds of unknown type -->
<xsl:template match="*" mode="compound"/>

<xsl:template match="member[@kind='function' or @kind='typedef' or @kind='enumeration' or @kind='enumvalue' or @kind='define']" mode="symbol">
<xsl:value-of select="concat(../name, '::', name)"/>
<xsl:text> </xsl:text>
<xsl:value-of select="concat($base-path, anchorfile, '#', anchor)"/>
<xsl:text>
</xsl:text>
</xsl:template>
<!-- Ignore symbols of unknown type -->
<xsl:template match="*" mode="symbol"/>

</xsl:stylesheet>
