// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_WINDOW_H
#define _HILDONMM_WINDOW_H


#include <glibmm.h>

/*
 * Copyright (c) 2005-2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/app-menu.h>
#include <hildonmm/edit-toolbar.h>
#include <gtkmm/window.h>
#include <gtkmm/menu.h>
#include <gtkmm/toolbar.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonWindow HildonWindow;
typedef struct _HildonWindowClass HildonWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Window_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::Window is a top-level window of an application running in the Hildon framework. 
 * It provides facilities to manage window menus and toolbars. 
 *
 * Each Hildon::Window can have its own menu and toolbars. The application can also have a common 
 * menu and toolbar, which are shared among all application windows. 
 * For more information, see Hildon::Program.
 *
 * The following methods are particularly important:
 * - set_main_menu() sets a menu for the Hildon::Window.
 * - add_toolbar() adds a toolbar for the Hildon::Window.
 */

class Window : public Gtk::Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef HildonWindow BaseObjectType;
  typedef HildonWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Window();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Window_Class;
  static CppClassType window_class_;

  // noncopyable
  Window(const Window&);
  Window& operator=(const Window&);

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(HildonWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonWindow*       gobj()       { return reinterpret_cast<HildonWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonWindow* gobj() const { return reinterpret_cast<HildonWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  Window();

  
  /** Adds @a child to the Hildon::Window and creates a scrollbar for
   * it. Similar to adding first a Gtk::ScrolledWindow and then @a child to
   * it.
   * @param child A Gtk::Widget.
   */
  void add_with_scrollbar(Gtk::Widget& child);

  
  /** Sets the menu to be used for this window. This menu overrides
   * a program-wide menu that may have been set with
   * Hildon::Program::set_common_menu(). Pass <tt>0</tt> to remove the current
   * menu. Hildon::Window takes ownership of the passed menu and you're
   * not supposed to free it yourself anymore.
   * 
   * Note that if you're using a Hildon::AppMenu rather than a Gtk::Menu
   * you should use set_app_menu() instead.
   * @param menu The Gtk::Menu to be used for this Hildon::Window.
   */
  void set_main_menu(Gtk::Menu& menu);
  void unset_main_menu();
  
  /** Gets the Gtk::Menu assigned to the Hildon::Window. Note that the
   * window is still the owner of the menu.
   * 
   * Note that if you're using a Hildon::AppMenu rather than a Gtk::Menu
   * you should use get_app_menu() instead.
   * @return The Gtk::Menu assigned to this application view. 
   * 
   * @newin2p2.
   */
  Gtk::Menu* get_main_menu();
  
  /** Gets the Gtk::Menu assigned to the Hildon::Window. Note that the
   * window is still the owner of the menu.
   * 
   * Note that if you're using a Hildon::AppMenu rather than a Gtk::Menu
   * you should use get_app_menu() instead.
   * @return The Gtk::Menu assigned to this application view. 
   * 
   * @newin2p2.
   */
  const Gtk::Menu* get_main_menu() const;

  
  /** Sets the menu to be used for this window. Pass <tt>0</tt> to remove the
   * current menu. Any reference to a previous menu will be dropped.
   * Hildon::Window takes ownership of the passed menu and
   * you're not supposed to free it yourself anymore.
   * 
   * Note that if you're using a Gtk::Menu rather than a Hildon::AppMenu
   * you should use set_main_menu() instead.
   * 
   * @newin2p2
   * @param menu A Hildon::AppMenu to be used for this window.
   */
  void set_app_menu(AppMenu& menu);
  void unset_app_menu();
  
  /** Returns: a Hildon::AppMenu
   * @return A Hildon::AppMenu
   * 
   * @newin2p2.
   */
  AppMenu* get_app_menu();
  
  /** Returns: a Hildon::AppMenu
   * @return A Hildon::AppMenu
   * 
   * @newin2p2.
   */
  const AppMenu* get_app_menu() const;

  
  /** Adds a toolbar to the window. Note that the toolbar is not automatically
   * shown. You need to call gtk_widget_show_all() on it to make it visible.
   * It's also possible to hide the toolbar (without removing it) by calling
   * gtk_widget_hide()
   * @param toolbar A Gtk::Toolbar to add to the Hildon::Window.
   */
  void add_toolbar(Gtk::Toolbar& toolbar);
  
  /** Removes a toolbar from the window. Note that this decreases the refference
   * count on the widget. If you want to keep the toolbar alive call Glib::object_ref()
   * before calling this function.
   * @param toolbar A Gtk::Toolbar to remove from the Hildon::Window.
   */
  void remove_toolbar(Gtk::Toolbar& toolbar);

  
  /** Adds a Hildon::EditToolbar to the window. Note that the toolbar is
   * not automatically shown. You need to call gtk_widget_show() on it
   * to make it visible. It's also possible to hide the toolbar (without
   * removing it) by calling gtk_widget_hide().
   * 
   * A window can only have at most one edit toolbar at a time, so the
   * previous toolbar (if any) is replaced after calling this function.
   * 
   * @newin2p2
   * @param toolbar A Hildon::EditToolbar, or <tt>0</tt> to remove the current one.
   */
  void set_edit_toolbar(EditToolbar& toolbar);
  void unset_edit_toolbar();

  
  /** Return value: <tt>true</tt> if @a self is currently activated, <tt>false</tt> otherwise.
   * @return <tt>true</tt> if @a self is currently activated, <tt>false</tt> otherwise.
   */
  bool get_is_topmost() const;

  // We don't wrap this because it is documented as "opera hack", so it is unlikely to be useful:
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the window is currently activated by the window manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_topmost() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::Window
   */
  Hildon::Window* wrap(HildonWindow* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_WINDOW_H */

