// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_TOUCH_SELECTOR_H
#define _HILDONMM_TOUCH_SELECTOR_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/touch-selector-column.h>
#include <gtkmm/cellrenderer.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeselection.h>
#include <gtkmm/box.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonTouchSelector HildonTouchSelector;
typedef struct _HildonTouchSelectorClass HildonTouchSelectorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class TouchSelector_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildonmmEnums Enums and Flags */

/**
 * @ingroup hildonmmEnums
 */
enum TouchSelectorSelectionMode
{
  TOUCH_SELECTOR_SELECTION_MODE_SINGLE,
  TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::TouchSelectorSelectionMode> : public Glib::Value_Enum<Hildon::TouchSelectorSelectionMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{


/** A selector widget with several columns.
 *
 * Hildon::TouchSelector is a selector widget, that allows users to select items
 * from one to many predefined lists. It is very similar to Gtk::ComboBox, but
 * with several individually pannable columns.
 *
 * Normally, you would use Hildon::TouchSelector together with a
 * Hildon::PickerDialog activated from a button. For the most common cases, you
 * should use Hildon::PickerButton.
 *
 * The composition of each column in the selector is represented by a
 * Gtk::TreeModel. To add a new column to a Hildon::TouchSelector, use
 * Hildon::TouchSelector::append_column(). If you want to add a text-only
 * column, without special attributes, use Hildon::TouchSelector::append_text_column().
 *
 * It is highly recommended that you use only one-column Hildon::TouchSelector<!-- -->s.
 * If you only need a text-only, one column selector, you can use the simpler TouchSelectorText class.
 *
 * If you need a selector widget that also accepts user inputs, you can use
 * Hildon::TouchSelectorEntry.
 *
 * The current selection has a string representation. In the most common cases,
 * each column model will contain a text column. You can configure which column
 * in particular using Hildon::TouchSelectorColumn::property_text_column().
 *
 * You can get this string representation using
 * Hildon::TouchSelector::get_current_text(). You can configure how the
 * selection is printed with Hildon::TouchSelector::set_print_func(), that sets
 * the current hildon touch selector print function. The widget has a default
 * print function, that uses the Hildon::TouchSelectorColumn::property_text_column()
 * on each Hildon::TouchSelectorColumn to compose the final representation.
 */

class TouchSelector : public Gtk::VBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TouchSelector CppObjectType;
  typedef TouchSelector_Class CppClassType;
  typedef HildonTouchSelector BaseObjectType;
  typedef HildonTouchSelectorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TouchSelector();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TouchSelector_Class;
  static CppClassType touchselector_class_;

  // noncopyable
  TouchSelector(const TouchSelector&);
  TouchSelector& operator=(const TouchSelector&);

protected:
  explicit TouchSelector(const Glib::ConstructParams& construct_params);
  explicit TouchSelector(HildonTouchSelector* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonTouchSelector*       gobj()       { return reinterpret_cast<HildonTouchSelector*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonTouchSelector* gobj() const { return reinterpret_cast<HildonTouchSelector*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_changed(int column);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

   
public:
  typedef TouchSelectorColumn Column;
  typedef TouchSelectorSelectionMode SelectionMode;

  TouchSelector();
  

  //The *_text() functions have equivalents in the TouchSelectorText class.
  ;
  /*
  _WRAP_METHOD(void append_text(const Glib::ustring& text), hildon_touch_selector_append_text)
  _WRAP_METHOD(void prepend_text(const Glib::ustring& text), hildon_touch_selector_prepend_text)
  _WRAP_METHOD(void insert_text(int position, const Glib::ustring& text),
               hildon_touch_selector_insert_text)
  */

  //See https://bugs.maemo.org/show_bug.cgi?id=4642 about the ref-counting documentation.
  
  /** Equivalent to append_column(), but using a
   * default text cell renderer. This is the most common use case of the
   * widget.
   * @param model A Gtk::TreeModel with data for the column.
   * @param center Whether to center the text on the column.
   * @return The new column added, <tt>0</tt> otherwise.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<TouchSelectorColumn>
               append_text_column(const Glib::RefPtr<Gtk::TreeModel>& model, bool center = false);

  template <class ColumnType> inline
  Glib::RefPtr<TouchSelectorColumn> append_text_column(const Glib::RefPtr<Gtk::TreeModel>& model, const Gtk::TreeModelColumn<ColumnType>& model_column, bool center = false);

  
  /** This functions adds a new column to the widget, whose data will
   * be obtained from the model. Only widgets added this way should used on
   * the selection logic, the print function, the Hildon::TouchSelector::changed
   * signal, etc. Internally, a Gtk::TreeView will be added to the widget, using
   *  @a model as the data source.
   * 
   * You can optionally pass a Gtk::CellRenderer in @a cell_renderer,
   * together with a <tt>0</tt>-terminated list of pairs property/value, in
   * the same way you would use gtk_tree_view_column_set_attributes().
   * This will pack @a cell_renderer at the start of the column, expanded
   * by default.  If you prefer not to add it this way, you can simply
   * pass <tt>0</tt> to @a cell_renderer and use the Gtk::CellLayout interface
   * on the returned Hildon::TouchSelectorColumn to set your
   * renderers. Please note that the returned Hildon::TouchSelectorColumn
   * is owned by @a selector, you shouldn't unref it after setting it
   * up.
   * 
   * Initially, the returned Hildon::TouchSelectorColumn will have its
   * Hildon::TouchSelectorColumn:text-column property unset. You should set
   * it to a column in @a model with type TYPE_STRING. See
   * Hildon::TouchSelectorColumn::set_text_column().
   * @param model The Gtk::TreeModel with the data of the column.
   * @param cell_renderer The Gtk::CellRenderer where to draw each row contents.
   * @param Varargs A <tt>0</tt>-terminated pair of attributes and column numbers.
   * @return The new column added added, <tt>0</tt> otherwise.
   * 
   * @newin2p2.
   */

  Glib::RefPtr<TouchSelectorColumn> append_column(const Glib::RefPtr<Gtk::TreeModel>& model,
                                                  Gtk::CellRenderer& cell_renderer);

  
  /** Removes a column from @a selector.
   * @param column The position of the column to be removed.
   * @return <tt>true</tt> if the column was removed, <tt>false</tt> otherwise
   * 
   * @newin2p2.
   */
  bool remove_column(int column);
  
  /** Gets the number of columns in the Hildon::TouchSelector.
   * @return The number of columns in @a selector.
   * 
   * @newin2p2.
   */
  int get_num_columns() const;

  
  /** Sets the selection mode for @a selector. See Hildon::TouchSelectorSelectionMode.
   * 
   * @newin2p2
   * @param mode The Hildon::TouchSelectorMode for @a selector.
   */
  void set_column_selection_mode(TouchSelectorSelectionMode mode);
  
  /** Gets the selection mode of @a selector.
   * @return One of Hildon::TouchSelectorSelectionMode
   * 
   * @newin2p2.
   */
  TouchSelectorSelectionMode get_column_selection_mode() const;

  
  /** Use this method to retrieve a Hildon::TouchSelectorColumn. Then, you can use
   * the Gtk::CellLayout interface to set up the layout of the column.
   * @param column A column number.
   * @return The @a column<!-- -->-th Hildon::TouchSelectorColumn in @a selector
   * 
   * @newin2p2.
   */
  Glib::RefPtr<TouchSelectorColumn> get_column(int column);
  
  /** Use this method to retrieve a Hildon::TouchSelectorColumn. Then, you can use
   * the Gtk::CellLayout interface to set up the layout of the column.
   * @param column A column number.
   * @return The @a column<!-- -->-th Hildon::TouchSelectorColumn in @a selector
   * 
   * @newin2p2.
   */
  Glib::RefPtr<const TouchSelectorColumn> get_column(int column) const;

  
  /** Sets the active item of the Hildon::TouchSelector to @a index. The
   * column number is taken from @a column.
   * 
   *  @a selector must be in Hildon::TOUCH_SELECTOR_SELECTION_MODE_SINGLE
   * 
   * @newin2p2
   * @param column Column number.
   * @param index The index of the item to select, or -1 to have no active item.
   */
  void set_active(int column, int index);
  void set_active(int column, const Gtk::TreeModel::iterator& iter);

  /** Causes no item to be active. See also set_active().
   */
  void unset_active(int column);

  
  /** Returns: an integer which is the index of the currently active
   * @param column Column number.
   * @return An integer which is the index of the currently active
   * item, or -1 if there's no active item.
   * 
   * @newin2p2.
   */
  int get_active_row_number(int column = 0) const;

  /** Gets an iterator that points to the current active item, if it exists.
   * @result The iterator.
   */
  Gtk::TreeModel::iterator get_active(int column = 0) const;

  
  /** Sets @a iter to the currently selected node on the nth-column, if selection is
   * set to Hildon::TOUCH_SELECTOR_SINGLE or Hildon::TOUCH_SELECTOR_MULTIPLE with
   * a column different that the first one. @a iter may be <tt>0</tt> if you just want to
   * test if selection has any selected items.
   * 
   * This function will not work if selection is in
   * Hildon::TOUCH_SELECTOR_MULTIPLE mode and the column is the first one.
   * 
   * See gtk_tree_selection_get_selected() for more information.
   * @param column The column number we want to get the element.
   * @param iter Gtk::TreeIter currently selected.
   * @return <tt>true</tt> if @a iter was correctly set, <tt>false</tt> otherwise
   * 
   * @newin2p2.
   */

  Gtk::TreeModel::iterator get_selected(int column);

  
  /** Sets the currently selected item in the column @a column to the one pointed by @a iter,
   * optionally smoothly scrolling to it.
   * 
   * @newin2p2
   * @param column The column to selects.
   * @param iter The Gtk::TreeIter to be selected.
   * @param scroll_to Whether to smoothly scroll to the item.
   */
  void select_iter(int column, const Gtk::TreeModel::iterator& iter, bool scroll_to);
  
  /** Unselect the item pointed by @a iter in the column @a column
   * 
   * @newin2p2
   * @param column The column to unselects from.
   * @param iter The Gtk::TreeIter to be unselected.
   */
  void unselect_iter(int column, const Gtk::TreeModel::iterator& iter);
  
  /** Unselects all the selected items in the column @a column.
   * 
   * @newin2p2
   * @param column The position of the column to get the selected rows from.
   */
  void unselect_all(int column);


  /** Creates a list of Gtk::TreePath<!-- -->s of all selected rows in a column. Additionally,
   * if you to plan to modify the model after calling this function, you may
   * want to convert the returned list into a list of GtkTreeRowReferences. To do this,
   * you can use gtk_tree_row_reference_new().
   * 
   * See gtk_tree_selection_get_selected_rows() for more information.
   * @param column The position of the column to get the selected rows from.
   * @return A new List containing a Gtk::TreePath for each selected row in the column @a column.
   * 
   * @newin2p2.
   */
  Gtk::TreeSelection::ListHandle_Path get_selected_rows(int column) const;

  
  /** Sets the Gtk::TreeModel for a particular column in @a model.
   * 
   * @newin2p2
   * @param column The position of the column to set the model to.
   * @param model A Gtk::TreeModel.
   */
  void set_model(int column, const Glib::RefPtr<Gtk::TreeModel>& model);
  
  /** Gets the model of a column of @a selector.
   * @param column The position of the column in @a selector.
   * @return The Gtk::TreeModel for the column @a column of @a selector.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<Gtk::TreeModel> get_model(int column);
  
  /** Gets the model of a column of @a selector.
   * @param column The position of the column in @a selector.
   * @return The Gtk::TreeModel for the column @a column of @a selector.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<const Gtk::TreeModel> get_model(int column) const;

  
  /** Returns: a newly allocated string.
   * @return A newly allocated string.
   * 
   * @newin2p2.
   */
  Glib::ustring get_current_text() const;

   
  /** Sets the function to be used by get_current_text().
   * See set_print_func_full().
   * 
   * @newin2p2
   * @param func A Hildon::TouchSelectorPrintFunc function.
   */

  void set_print_func(const sigc::slot<Glib::ustring>& func);

  /** Causes no custom TouchSelectorPrintFunc to be active.
   *
   * @see_also: set_print_func()
   */
  void unset_print_func();

  
  /** Determines whether @a selector is complex enough to actually require an
   * extra selection step than only picking an item. This is normally <tt>true</tt>
   * if @a selector has multiple columns, multiple selection, or when it is a
   * more complex widget, like Hildon::TouchSelectorEntry.
   * 
   * This information is useful for widgets containing a Hildon::TouchSelector,
   * like Hildon::PickerDialog, that could need a "Done" button, in case that
   * its internal Hildon::TouchSelector has multiple columns, for instance.
   * @return <tt>true</tt> if @a selector requires multiple selection steps.
   * 
   * @newin2p2.
   */
  bool has_multiple_selection() const;
  
  /** Ensures all the columns in a Hildon::TouchSelector show a selected
   * item. If one of the columns is in
   * Hildon::TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE mode, that column
   * will be scrolled to ensure the selected item that is closest to the
   * currently visible area is shown.
   * 
   * @newin2p2
   */
  void center_on_selected();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%changed(int column)</tt>
   */

  Glib::SignalProxy1< void,int > signal_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%columns_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_columns_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget has multiple selection (like multiple columns, multiselection mode, or multiple internal widgets) and therefore it may need a confirmation button
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_multiple_selection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to scroll to thecurrent selection whenthe selector is firstshown.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_initial_scroll() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to scroll to thecurrent selection whenthe selector is firstshown.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_initial_scroll() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_model_vfunc(int column, const Glib::RefPtr<Gtk::TreeModel>& model);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool has_multiple_selection_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED


};

template <class ColumnType> inline
Glib::RefPtr<TouchSelectorColumn> TouchSelector::append_text_column(const Glib::RefPtr<Gtk::TreeModel>& model, const Gtk::TreeModelColumn<ColumnType>& model_column, bool center)
{
  Glib::RefPtr<Hildon::TouchSelectorColumn> touch_selector_column =
    append_text_column(model, center);
  touch_selector_column->set_property("text-column", model_column.index());

  return touch_selector_column;
}

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::TouchSelector
   */
  Hildon::TouchSelector* wrap(HildonTouchSelector* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_TOUCH_SELECTOR_H */

