// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_PICKER_BUTTON_H
#define _HILDONMM_PICKER_BUTTON_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/button.h>
#include <hildonmm/touch-selector.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonPickerButton HildonPickerButton;
typedef struct _HildonPickerButtonClass HildonPickerButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class PickerButton_Class; } // namespace Hildon
namespace Hildon
{

/** A button that launches a Hildon::PickerDialog and displays the selected item.
 *
 * The PickerButton widget lets the user select a particular item
 * from a list. Visually, it's a button with title and value labels that brings
 * up a Hildon::PickerDialog. The user can then use this dialog to choose an
 * item, which will be displayed in the value label of the button.
 *
 * You should create your own Hildon::TouchSelector at convenience and set it
 * to the Hildon::PickerButton with Hildon::PickerButton::set_selector(). For
 * the common use cases of buttons to select date and time, you can use
 * Hildon::DateButton and Hildon::TimeButton.
 *
 * @see Hildon::TouchSelector, Hildon::PickerDialog
 *
 * @ingroup HildonWidgets
 */

class PickerButton : public Button
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PickerButton CppObjectType;
  typedef PickerButton_Class CppClassType;
  typedef HildonPickerButton BaseObjectType;
  typedef HildonPickerButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~PickerButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class PickerButton_Class;
  static CppClassType pickerbutton_class_;

  // noncopyable
  PickerButton(const PickerButton&);
  PickerButton& operator=(const PickerButton&);

protected:
  explicit PickerButton(const Glib::ConstructParams& construct_params);
  explicit PickerButton(HildonPickerButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonPickerButton*       gobj()       { return reinterpret_cast<HildonPickerButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonPickerButton* gobj() const { return reinterpret_cast<HildonPickerButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  PickerButton();
  explicit PickerButton(Gtk::Hildon::SizeType size, ButtonArrangement arrangement);

  
  /** Sets @a selector as the Hildon::TouchSelector to be shown in the
   * Hildon::PickerDialog that @a button brings up.
   * 
   * @newin2p2
   * @param selector A Hildon::TouchSelector.
   */
  void set_selector(TouchSelector& selector);
  
  /** Retrieves the Hildon::TouchSelector associated to @a button.
   * @return A Hildon::TouchSelector
   * 
   * @newin2p2.
   */
  TouchSelector* get_selector();
  
  /** Retrieves the Hildon::TouchSelector associated to @a button.
   * @return A Hildon::TouchSelector
   * 
   * @newin2p2.
   */
  const TouchSelector* get_selector() const;

  
  /** Sets the active item of the Hildon::TouchSelector associated to
   *  @a button to @a index. If the selector has several columns, only the
   * first one is used.
   * 
   * @newin2p2
   * @param index The index of the item to select, or -1 to have no active item.
   */
  void set_active(int index);
  
  /** Returns: an integer which is the index of the currently active item, or -1 if there's no active item.
   * @return An integer which is the index of the currently active item, or -1 if there's no active item.
   * 
   * @newin2p2.
   */
  int get_active() const;

  
  /** Sets a custom string to be used in the "done" button in Hildon::PickerDialog.
   * If unset, the default HildonPickerButton::done-button-text property
   * value will be used.
   * 
   * @newin2p2
   * @param done_button_text A string.
   */
  void set_done_button_text(const Glib::ustring& done_button_text);
  
  /** Gets the text used in the Hildon::PickerDialog that is launched by
   * the Hildon::PickerButton.
   * 
   * @newin2p2
   * @return The custom string to be used.
   */
  Glib::ustring get_done_button_text() const;

  
  /** Emits a "Hildon::PickerButton::value-changed" signal to the given
   * Hildon::PickerButton
   * 
   * @newin2p2
   */
  void value_changed();
  
  /**
   * @par Prototype:
   * <tt>void on_my_%value_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_value_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** HildonTouchSelector widget to be launched on button clicked.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TouchSelector*> property_touch_selector() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** HildonTouchSelector widget to be launched on button clicked.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TouchSelector*> property_touch_selector() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The text for the 'done' button in the dialog launched.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_done_button_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The text for the 'done' button in the dialog launched.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_done_button_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::PickerButton
   */
  Hildon::PickerButton* wrap(HildonPickerButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_PICKER_BUTTON_H */

