// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_FIND_TOOLBAR_H
#define _HILDONMM_FIND_TOOLBAR_H


#include <glibmm.h>

/*
 * Copyright (c) 2005-2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/toolbar.h>
#include <gtkmm/liststore.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonFindToolbar HildonFindToolbar;
typedef struct _HildonFindToolbarClass HildonFindToolbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class FindToolbar_Class; } // namespace Hildon
namespace Hildon
{

/** A toolbar with a search field.
 *
 * The FindToolbar toolbar contains a search entry and a dropdown
 * list with previously searched strings. The list is represented using a
 * Gtk::ListStore and can be accessed via Hildon::FindToolbar::property_list().
 * Entries are added automatically to the list when the search button is
 * pressed.
 *
 * @see Hildon::Window
 *
 * @ingroup HildonWidgets
 */

class FindToolbar : public Gtk::Toolbar
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FindToolbar CppObjectType;
  typedef FindToolbar_Class CppClassType;
  typedef HildonFindToolbar BaseObjectType;
  typedef HildonFindToolbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FindToolbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FindToolbar_Class;
  static CppClassType findtoolbar_class_;

  // noncopyable
  FindToolbar(const FindToolbar&);
  FindToolbar& operator=(const FindToolbar&);

protected:
  explicit FindToolbar(const Glib::ConstructParams& construct_params);
  explicit FindToolbar(HildonFindToolbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonFindToolbar*       gobj()       { return reinterpret_cast<HildonFindToolbar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonFindToolbar* gobj() const { return reinterpret_cast<HildonFindToolbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_search();
  virtual void on_close();
  virtual void on_invalid_input();
  virtual bool on_history_append();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  FindToolbar();
  explicit FindToolbar(const Glib::ustring& label);
  explicit FindToolbar(const Glib::ustring& label, const Glib::RefPtr<Gtk::ListStore>& list,
                         int column);
  explicit FindToolbar(const Glib::ustring& label, const Glib::RefPtr<Gtk::ListStore>& list,
                         const Gtk::TreeModelColumnBase& column);

  
  /** Highlights the current entry in the find toolbar.
   * @param get_focus If user passes <tt>true</tt> to this value, then the text in
   * the entry will not only get highlighted, but also get focused.
   */
  void highlight_entry(bool get_focus = true);

  
  /** Sets the active item on the toolbar's combo-box. Simply calls gtk_combo_box_set_active on 
   * the HildonFindToolbar's combo.
   * @param index An index in the model passed during construction, or -1 to have no active item.
   */
  void set_active(int index);
  
  /** Gets the index of the currently active item, or -1 if there's no active item. Simply 
   * calls gtk_combo_box_get_active on the HildonFindToolbar's combo.
   * @return An integer which is the index of the currently active item, or -1 if there's no active item.
   */
  int get_active() const;

  
  /** Sets the current active item to be the one referenced by iter. Simply calls 
   * gtk_combo_box_set_active_iter on the HildonFindToolbar's combo.
   * @param iter An iter to make active.
   */
  void set_active_iter(const Gtk::TreeModel::iterator& iter);

  /** Get an iterator that points to the current active item.
   *
   * @return An iterator that points to the current active item, if it
   *  exists. Simply calls get_active_iter() on the FindToolbar's combo.
   */
  Gtk::TreeModel::iterator get_active_iter();
  

  /** Returns: Index of the last entry
   * @return Index of the last entry.
   */
  int get_last_index() const;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%search()</tt>
   */

  Glib::SignalProxy0< void > signal_search();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%close()</tt>
   */

  Glib::SignalProxy0< void > signal_close();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%invalid_input()</tt>
   */

  Glib::SignalProxy0< void > signal_invalid_input();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%history_append()</tt>
   */

  Glib::SignalProxy0< bool > signal_history_append();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Displayed name for find-toolbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Displayed name for find-toolbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Search string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_prefix() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Search string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_prefix() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkListStore model where history list is kept.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gtk::ListStore> > property_list() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkListStore model where history list is kept.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gtk::ListStore> > property_list() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Column number in GtkListStore where history list strings are kept.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Column number in GtkListStore where history list strings are kept.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of characters in search string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_characters() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of characters in search string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_characters() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of history items in search combobox.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_history_limit() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of history items in search combobox.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_history_limit() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::FindToolbar
   */
  Hildon::FindToolbar* wrap(HildonFindToolbar* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_FIND_TOOLBAR_H */

