#ifndef EVENTLISTMODEL_H
#define EVENTLISTMODEL_H

#include "database.h"
#include <QAbstractListModel>

class EventListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        EventIdRole = 0,
        SourceNameRole,
        SourceDisplayNameRole,
        IconRole,
        TitleRole,
        BodyRole,
        ImagesRole,
        FooterRole,
        TimestampRole,
        ActionRole
    };

public:
    explicit EventListModel(Database *database, QObject *parent = 0);
    ~EventListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Event get(int row) const;
    bool removeEvent(int row);
    bool removeEventsBySourceName(const QString &sourceName);

public slots:
    void reloadEvents();

private:
    void loadEvents();
    void removeRow(int row, const QModelIndex &parent = QModelIndex());

signals:
    void countChanged(int count);

private:
    QList<Event> m_list;
    Database *m_database;
};

#endif // EVENTLISTMODEL_H
