#ifndef ACTIONLAUNCHER_H
#define ACTIONLAUNCHER_H

#include <QObject>
#include <QProcess>
#include <QStringList>

class ActionLauncher : public QObject
{
    Q_OBJECT

public:
    explicit ActionLauncher(QObject *parent = 0);
        
public slots:
    void launchAction(const QString &action);
    void launchActions(QStringList actions);

private:
    QStringList parseAction(const QString &action);

private slots:
    void onProcessError(QProcess::ProcessError error);

signals:
    void error(const QString &errorString);
};

#endif // ACTIONLAUNCHER_H
