#ifndef DATABASE_H
#define DATABASE_H

#include "event.h"
#include <QObject>
#include <QSqlDatabase>
#include <QList>

class Database : public QObject {
    Q_OBJECT

public:
    explicit Database(QObject *parent = 0);
    ~Database();
    void initialize();
    bool addEvent(qint64 eventId,
                  const QString &sourceName,
                  const QString &sourceDisplayName,
                  const QString &icon,
                  const QString &title,
                  const QString &body,
                  const QStringList &images,
                  const QString &footer,
                  qint64 timestamp,
                  const QString &action);
    bool removeEvent(qint64 eventId);
    bool removeEventsBySourceName(const QString &sourceName);
    bool addRefreshAction(const QString &sourceName, const QString &refreshAction);
    bool removeRefreshAction(const QString &sourceName);
    QString getRefreshAction(const QString &sourceName);
    QStringList getRefreshActions();
    QList<Event> getEvents();

private:
    QSqlDatabase m_database;
};

#endif // DATABASE_H
