#ifndef EVENTS_H
#define EVENTS_H

#include "database.h"
#include "imagedownloader.h"
#include <QObject>
#include <QTimer>

class Events : public QObject
{
    Q_OBJECT

public:
    explicit Events(QObject *parent = 0);
    ~Events() {}
        
public slots:
    qlonglong addEvent(const QString &sourceName,
                       const QString &sourceDisplayName,
                       const QString &icon,
                       const QString &title,
                       const QString &body,
                       const QStringList &images,
                       const QString &footer,
                       QString timestamp,
                       const QString &action);
    bool removeEvent(qlonglong eventId);
    bool removeEventsBySourceName(const QString &sourceName);
    bool addRefreshAction(const QString &sourceName, const QString &action);
    bool removeRefreshAction(const QString &sourceName);
    QString getRefreshAction(const QString &sourceName);

private:
    void getNextEvent();
    void clearUnusedImages();

private slots:
    void onImagesDownload(const Event &event);
    void notify();

signals:
    void eventsUpdated();
    void refreshActionsUpdated();

private:
    Database m_database;
    ImageDownloader *m_downloader;
    QTimer m_timer;
    QList<Event> m_eventQueue;
    int m_newEvents;
};

#endif // EVENTS_H
