#include "widgetbutton.h"
#include <QPainter>

WidgetButton::WidgetButton(const QIcon &icon, const QString &background, QWidget *parent) :
    QAbstractButton(parent),
    m_background(QString("/etc/hildon/theme/images/%1.png").arg(background)),
    m_backgroundPressed(QString("/etc/hildon/theme/images/%1Pressed.png").arg(background))
{
    setIcon(icon);
    setFixedHeight(56);
}

void WidgetButton::paintEvent(QPaintEvent *event) {
    Q_UNUSED(event);

    QPainter painter(this);
    painter.drawImage(rect(), isDown() ? QImage(m_backgroundPressed) : QImage(m_background));
    icon().paint(&painter, rect());
}
