#include "settingsdialog.h"
#include "separatorlabel.h"
#include <QSettings>

SettingsDialog::SettingsDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_notificationCheckbox(new QCheckBox(tr("Show notifications of events"), this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Save, Qt::Vertical, this)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Settings"));

    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);
    vbox->addWidget(new SeparatorLabel(tr("Notifications"), this));
    vbox->addWidget(m_notificationCheckbox);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(saveSettings()));
    connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    loadSettings();
    onOrientationChanged();
}

void SettingsDialog::setLandscapeLayout() {
    setFixedHeight(200);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void SettingsDialog::setPortraitLayout() {
    setFixedHeight(400);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void SettingsDialog::loadSettings() {
    QSettings settings("Event Feed", "HildonEvents");
    settings.beginGroup("Notifications");
    m_notificationCheckbox->setChecked(settings.value("showNotifications", false).toBool());
    settings.endGroup();
}

void SettingsDialog::saveSettings() {
    QSettings settings("Event Feed", "HildonEvents");
    settings.beginGroup("Notifications");
    settings.setValue("showNotifications", m_notificationCheckbox->isChecked());
    settings.endGroup();

    accept();
}
