#ifndef IMAGEDOWNLOADER_H
#define IMAGEDOWNLOADER_H

#include "event.h"
#include <QObject>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QFile>

class ImageDownloader : public QObject
{
    Q_OBJECT
public:
    explicit ImageDownloader(QObject *parent = 0);

public slots:
    void downloadImages(Event event);

private:
    void getNextImage();
    void downloadImage(const QUrl &url, const char *slot);
    void downloadImageOne(const QUrl &url);
    void downloadImageTwo(const QUrl &url);

private slots:
    void onIconDownloaded();
    void onImageOneDownloaded();
    void onImageTwoDownloaded();

signals:
    void imagesDownloaded(const Event &event);
    
private:
    QNetworkAccessManager *m_nam;
    Event m_event;
};

#endif // IMAGEDOWNLOADER_H
