#include "stackedwindow.h"
#include <QApplication>
#include <QDesktopWidget>

StackedWindow::StackedWindow(QWidget *parent) :
    QMainWindow(parent),
    m_portrait(false)
{
    setAttribute(Qt::WA_Maemo5StackedWindow, true);
    setAttribute(Qt::WA_DeleteOnClose, true);

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(onOrientationChanged()));
}

void StackedWindow::setOrientation(ScreenOrientation::Orientation orientation) {
    switch (orientation) {
    case ScreenOrientation::Automatic:
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);
        break;
    case ScreenOrientation::LockPortrait:
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
        break;
    case ScreenOrientation::LockLandscape:
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
        break;
    default:
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
    }
}

void StackedWindow::onOrientationChanged() {
    QRect screen = QApplication::desktop()->screenGeometry();

    if (screen.width() > screen.height()) {
        m_portrait = false;
        setLandscapeLayout();
    }
    else {
        m_portrait = true;
        setPortraitLayout();
    }
}

void StackedWindow::toggleBusy(bool busy) {
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, busy);
}
