#include "settingsdialog.h"
#include <QSettings>

SettingsDialog::SettingsDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_orientationSelector(new ScreenOrientationSelector(tr("Screen orientation"), this)),
    m_languageSelector(new LanguageSelector(tr("Language"), true, this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Save, Qt::Vertical, this)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Settings"));

    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);
    vbox->addWidget(m_orientationSelector);
    vbox->addWidget(m_languageSelector);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(saveSettings()));
    connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    loadSettings();
    onOrientationChanged();
}

void SettingsDialog::setLandscapeLayout() {
    setFixedHeight(180);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void SettingsDialog::setPortraitLayout() {
    setFixedHeight(250);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void SettingsDialog::loadSettings() {
    QSettings settings("Event Feed", "HildonEvents");
    settings.beginGroup("Other");
    m_orientationSelector->setValue(static_cast<ScreenOrientation::Orientation>(settings.value("screenOrientation", 0).toInt()));
    m_languageSelector->setValue(settings.value("language", "en").toString());
    settings.endGroup();
}

void SettingsDialog::saveSettings() {
    QSettings settings("Event Feed", "HildonEvents");
    settings.beginGroup("Other");
    settings.setValue("screenOrientation", ScreenOrientation::Orientation(m_orientationSelector->currentValue()));
    settings.setValue("language", m_languageSelector->currentValue());
    settings.endGroup();

    accept();
}
