#ifndef EVENTLISTWIDGET_H
#define EVENTLISTWIDGET_H

#include "actionlauncher.h"
#include "database.h"
#include "eventlistmodel.h"
#include "listview.h"
#include "widgetbutton.h"
#include <QWidget>
#include <QGridLayout>
#include <QLabel>

class EventListWidget : public QWidget
{
    Q_OBJECT

public:
    explicit EventListWidget(QWidget *parent = 0);
    void paintEvent(QPaintEvent *event);

public slots:
    void showSettingsDialog();

private slots:
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void onEventsUpdated();
    void onRefreshActionsUpdated();
    void refresh();
    
private:
    ActionLauncher *m_actionLauncher;
    Database *m_database;
    EventListModel *m_model;
    ListView *m_listView;
    WidgetButton *m_upButton;
    WidgetButton *m_refreshButton;
    WidgetButton *m_downButton;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // EVENTLISTWIDGET_H
