#include "eventlistwindow.h"
#include "utils.h"
#include "eventsadaptor.h"
#include <QApplication>
#include <QTranslator>
#include <QSettings>

int main(int argc, char *argv[]) {
    QApplication app(argc, argv);
    app.setApplicationName("Event Feed");
    app.setApplicationVersion(Utils::versionNumberString());

    QSettings settings("Event Feed", "HildonEvents");
    settings.beginGroup("Other");
    QString lang = settings.value("language").toString();
    ScreenOrientation::Orientation orientation = static_cast<ScreenOrientation::Orientation>(settings.value("screenOrientation").toInt());
    settings.endGroup();

    QTranslator translator;
    translator.load(QString("/opt/hildonevents/translations/hildonevents_") + lang);
    app.installTranslator(&translator);

    EventListWindow window;

    new EventsAdaptor(&window);
    QDBusConnection connection = QDBusConnection::sessionBus();
    connection.registerService("com.maemo.eventFeedUI");
    connection.registerObject("/", &window);

    window.setOrientation(orientation);
    window.show();

    return app.exec();
}
