#ifndef EVENTLISTWINDOW_H
#define EVENTLISTWINDOW_H

#include "stackedwindow.h"
#include "actionlauncher.h"
#include "database.h"
#include "eventlistmodel.h"
#include "listview.h"
#include <QLabel>
#include <QAction>
#include <QMenu>

class EventListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit EventListWindow(QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onActionError(const QString &errorString);
    void onEventsUpdated();
    void onRefreshActionsUpdated();
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void removeEvent();
    void removeEventsBySourceName();
    void refreshAll();
    void showAboutDialog();
    void showSettingsDialog();

signals:
    void eventsUpdated();

private:
    ActionLauncher *m_actionLauncher;
    Database *m_database;
    EventListModel *m_model;
    ListView *m_listView;
    QMenu *m_contextMenu;
    QAction *m_removeAction;
    QAction *m_removeAllAction;
    QAction *m_refreshAllAction;
    QAction *m_settingsAction;
    QAction *m_aboutAction;
    QLabel *m_noResultsLabel;
};

#endif // EVENTLISTWINDOW_H
