/* Copyright: (c) 2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _MAEMOMM_EXAMPLE_DESKTOP_WIDGET_H
#define _MAEMOMM_EXAMPLE_DESKTOP_WIDGET_H

#include <libhildondesktopmm/home-plugin-item.h>
#include <libhildondesktop/libhildondesktop.h>

extern "C"
{

//Entry-points that hildon-desktop looks for in the desktop widget's shared library:
void hd_plugin_module_load(HDPluginModule* plugin);
void hd_plugin_module_unload(HDPluginModule* plugin);

}

class ExampleDesktopWidget : public HildonDesktop::HomePluginItem
{
public:
  ExampleDesktopWidget();
  virtual ~ExampleDesktopWidget();

private:
  void draw(const Cairo::RefPtr<Cairo::Context>& context);

  //Signal handlers:
  bool on_timeout();
  
  void on_realize();
  bool on_expose_event(GdkEventExpose* event);
  bool on_button_press_event(GdkEventButton* event);
  
  struct tm m_time;
  sigc::connection m_timeout_handler;
};

#endif // _MAEMOMM_EXAMPLE_DESKTOP_WIDGET_H
