#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include "systray-home-plugin.h"
#include "systray-process.h"

struct _SystrayHomePlugin {
	HDHomePluginItem __parent_instance__;

	gboolean visible;
};

struct _SystrayHomePluginClass {
	HDHomePluginItemClass __parent_class__;
};

HD_DEFINE_PLUGIN_MODULE(SystrayHomePlugin, systray_home_plugin, HD_TYPE_HOME_PLUGIN_ITEM);

static void
systray_home_plugin_class_finalize(SystrayHomePluginClass *klass)
{
}

static void
print_wid(GdkNativeWindow wid, GtkWidget *systray_home_plugin)
{
	char *str = g_strdup_printf("Embedding window with id %d. This string will be copied to the clipboard.", wid);
	gtk_clipboard_set_text(gtk_clipboard_get(gdk_atom_intern("CLIPBOARD", FALSE)), str, -1);
	hildon_banner_show_information(systray_home_plugin, GTK_STOCK_INFO, str);
	g_free(str);
}

static void
realize (GtkWidget *widget)
{
  GdkScreen *screen = gtk_widget_get_screen (widget);
  gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));
  gtk_widget_set_app_paintable (widget, TRUE);

  GTK_WIDGET_CLASS (systray_home_plugin_parent_class)->realize (widget);

	systray_setup(widget, HILDON_MARGIN_DEFAULT, HILDON_ICON_PIXEL_SIZE_THUMB, (WindowIDCallback)print_wid, widget);
}

static gboolean
expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	cairo_t *cr;

	cr = gdk_cairo_create(GDK_DRAWABLE(widget->window));
	gdk_cairo_region(cr, event->region);
	cairo_clip(cr);
  cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
  cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 0.0);
  cairo_paint (cr);
  
  cairo_destroy (cr);

  return GTK_WIDGET_CLASS (systray_home_plugin_parent_class)->expose_event (widget, event);
}


static void
systray_home_plugin_class_init(SystrayHomePluginClass *klass)
{
	GtkWidgetClass *gtkwidget_class = GTK_WIDGET_CLASS(klass);

	gtkwidget_class->realize      = realize;
	gtkwidget_class->expose_event = expose_event;
}

static void
systray_home_plugin_init(SystrayHomePlugin *systray_home_plugin)
{
}
