// -*- c++ -*-
/* $Id: init.cc,v 1.1 2003/11/03 09:27:31 murrayc Exp $ */

/* Copyright 2006 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/main.h>
#include <libnotifymm/init.h>
#include <hildon-notifymm/wrap_init.h>

namespace Hildon
{

void notify_init(const Glib::ustring& app_name)
{
  Gtk::Main::init_gtkmm_internals(); //Sets up the g type system and the Glib::wrap() table.
  wrap_init(); //Tells the Glib::wrap() table about the libpanelappletmm classes.
  //osso_initialize(program-name, version, deprecatedbool, glib context); //This is needed whenever the Hildon file stuff is used.
  
  // The underlying C libs does not do this but it's necessary anyway
  Notify::init(app_name);
}

} // namespace Hildon

