/*
 * Copyright (C) 2009-2010 Kimitake <kimitake@gmail.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <stdio.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <string.h>
#include <time.h>
#include <sys/timeb.h>

#include "log.h"

typedef enum {
	LOG_NOLOG = 0,
	LOG_ERROR,
	LOG_INFO,
	LOG_DEBUG,
} LOG_LEVEL;


const gchar log_conf[] = "/home/user/.him-scim/log.cnf";
const gchar log_file[] = "/home/user/MyDocs/tmp/him-scim.log";

//static gint log_level = LOG_NOLOG;
static gint log_level = LOG_DEBUG;
FILE *fp = NULL;

void log_init()
{
	if (fp)
		return;

#if 0
	fp = stderr;
#else
	fp = fopen(log_file, "a");
	if (fp)
		g_printf("opened log file\n");
#endif

	FILE *cnf = fopen("log_conf", "r");
	if (cnf) {


		fclose(cnf);
	}
}

void logDate()
{
	if (!fp)
		return;

	struct timeb tstruct;
	time_t ltime;
	struct tm *t;

	tzset();

	ftime(&tstruct);
	time(&ltime);
	t = localtime(&ltime);
	fprintf(fp, "[%04d/%02d/%02d %02d:%02d:%02d.%03d] ",
			1900+t->tm_year, t->tm_mon+1, t->tm_mday,
			t->tm_hour, t->tm_min, t->tm_sec, tstruct.millitm);
}

void logDebug(const gchar *fmt, ...)
{
	if (log_level < LOG_DEBUG)
		return;

	logDate();

	g_fprintf(fp, "[DEBUG] ");

	va_list ap;

	va_start(ap, fmt);
	g_vfprintf(fp, fmt, ap);
	va_end(ap);

	fflush(fp);
}

void logInfo(const gchar *fmt, ...)
{
	if (log_level < LOG_INFO)
		return;

	g_fprintf(fp, "[INFO] ");

	va_list ap;

	va_start(ap, fmt);
	g_vfprintf(fp, fmt, ap);
	va_end(ap);

	fflush(fp);
}

