;; -*-emacs-lisp-*-
;;
;; Emacs startup file, e.g.  /etc/emacs/site-start.d/50hildon-im-chewing-vkb.el
;; for the Debian hildon-im-chewing-vkb package
;;
;; Originally contributed by Nils Naumann <naumann@unileoben.ac.at>
;; Modified by Dirk Eddelbuettel <edd@debian.org>
;; Adapted for dh-make by Jim Van Zandt <jrv@debian.org>

;; The hildon-im-chewing-vkb package follows the Debian/GNU Linux 'emacsen' policy and
;; byte-compiles its elisp files for each 'emacs flavor' (emacs19,
;; xemacs19, emacs20, xemacs20...).  The compiled code is then
;; installed in a subdirectory of the respective site-lisp directory.
;; We have to add this to the load-path:
(let ((package-dir (concat "/usr/share/"
                           (symbol-name flavor)
                           "/site-lisp/hildon-im-chewing-vkb")))
;; If package-dir does not exist, the hildon-im-chewing-vkb package must have
;; removed but not purged, and we should skip the setup.
  (when (file-directory-p package-dir)
        (setq load-path (cons package-dir load-path))
       (autoload 'hildon-im-chewing-vkb-mode "hildon-im-chewing-vkb-mode"
         "Major mode for editing hildon-im-chewing-vkb files." t)
       (add-to-list 'auto-mode-alist '("\\.hildon-im-chewing-vkb$" . hildon-im-chewing-vkb-mode))))

