
#ifndef HHCAPPLET_H
#define HHCAPPLET_H

#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <glib.h>
#include <libhildondesktop/libhildondesktop.h>

typedef struct _HhcApplet               HhcApplet;
typedef struct _HhcAppletClass          HhcAppletClass;
typedef struct _HhcAppletPrivate        HhcAppletPrivate;

#define HHC_TYPE_APPLET            (hhc_applet_get_type ())
#define HHC_APPLET(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), HHC_TYPE_APPLET, HhcApplet))
#define HHC_APPLET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  HHC_TYPE_APPLET, HhcAppletClass))
#define HHC_IS_APPLET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HHC_TYPE_APPLET))
#define HHC_IS_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  HHC_TYPE_APPLET))
#define HHC_APPLET_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  HHC_TYPE_APPLET, HhcAppletClass))

struct _HhcApplet
{
  HDHomePluginItem         parent;

  HhcAppletPrivate             *priv;
};

struct _HhcAppletClass
{
  HDHomePluginItemClass   parent_class;
  
};

GType           hhc_applet_get_type             (void);

#define G_DEBUG_DISABLE 
#define CALENDAR_LUNAR_TYPE (calendar_lunar_get_type())
#define CALENDAR_LUNAR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), CALENDAR_LUNAR, calendar_lunar))
#define CALENDAR_LUNAR_GET_CLASS(obj) \
        (G_TYPE_INSTANCE_GET_CLASS ((obj), \
         CALENDAR_LUNAR_TYPE, calendar_lunar_class))

typedef gboolean (*date_update_func)();

typedef struct{
    GObject parent;
    date_update_func update;
}calendar_lunar;

typedef struct{
    GObjectClass parent_class;
}calendar_lunar_class;

GType calendar_lunar_get_type(void);
calendar_lunar* calendar_lunar_new(void);
//gboolean calendar_lunar_update( calendar_lunar* obj, GError **error);
//void calendar_lunar_set_key_func( calendar_lunar* conn, date_update_func func );
//gboolean hhc_applet_timeout_cb ();

#endif
