#include <time.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <lunar-date/lunar-date.h>

//#define MY_BUILD 1

typedef struct{
    GtkWidget *calendar;
    GtkWidget *label_holiday;
    GtkWidget *label_lunar;
    GtkWidget *date_picker;
} Calendar;

static void
window_destroy (GtkWidget* widget, gpointer data)
{
    if(data) g_free(data);
    gtk_main_quit();
}
static void
date_button_clicked (GtkWidget* button, gpointer data)
{
    Calendar *mycalendar;
    guint year,month,day,o_year,o_month,o_day;

    mycalendar=data;
    hildon_date_button_get_date(HILDON_DATE_BUTTON(mycalendar->date_picker),&year,&month,&day);
    hildon_calendar_get_date(HILDON_CALENDAR(mycalendar->calendar),&o_year,&o_month,&o_day);
    if(year==o_year && month==o_month && day==o_day)
         return;
    hildon_calendar_select_month(HILDON_CALENDAR(mycalendar->calendar),month,year);
    hildon_calendar_select_day(HILDON_CALENDAR(mycalendar->calendar),day);
}

static void
calendar_clicked (GtkWidget* calendar, gpointer data)
{
    LunarDate *date;
    Calendar *mycalendar;
    guint year,month,day;

    mycalendar=data;
    hildon_calendar_get_date(HILDON_CALENDAR(calendar),&year,&month,&day);
    hildon_date_button_set_date(HILDON_DATE_BUTTON(mycalendar->date_picker),year,month,day);
#ifdef MY_BUILD
    const gchar const *work[]={"休班第二天","中班","白班，夜班","休班第一天"};
    GDate *first = g_date_new_dmy(1,1,1970);
    GDate *end = g_date_new_dmy(day,month+1,year);
    gint index = g_date_days_between(first,end)%4;
#else
    const gchar const *work[]={" "};
    gint index = 0;
#endif
    date = lunar_date_new();
    lunar_date_set_solar_date(date, year, month+1, day, 1, NULL);
    gchar *text = g_strdup_printf("农历：%s\n\n<span font_desc='30'>%s</span>\n\n%s",lunar_date_strftime(date, "%(NIAN)[%(shengxiao)]年"),lunar_date_strftime(date, "%(YUE)月%(RI)日"),work[index]);
    gtk_label_set_markup(GTK_LABEL(mycalendar->label_lunar),text);
    gtk_label_set_text(GTK_LABEL(mycalendar->label_holiday),lunar_date_get_jieri(date, "\n"));
#ifdef MY_BUILD
    g_date_free(first);
    g_date_free(end);
#endif
    lunar_date_free(date);
    g_free(text);
}

static void
today (GtkWidget* button, gpointer data)
{
    Calendar *mycalendar;

    time_t tm;
    time(&tm);
    mycalendar=data;
    GDate *date = g_date_new();
    g_date_set_time_t(date,tm);
    hildon_date_button_set_date(HILDON_DATE_BUTTON(mycalendar->date_picker),g_date_year(date),g_date_month(date)-1,g_date_day(date));
    g_date_free(date);
}

static void
month (GtkWidget* button, gpointer data)
{
    Calendar *mycalendar;
    guint year,month,day;
    const gchar *text;

    mycalendar=data;
    text = gtk_button_get_label(GTK_BUTTON(button));
    hildon_date_button_get_date(HILDON_DATE_BUTTON(mycalendar->date_picker),&year,&month,&day);
    GDate *date = g_date_new_dmy(day,month+1,year);
    if(*text==0x3e)
        g_date_add_months(date, 1);
    else
        g_date_subtract_months(date, 1);
    if(g_date_year(date)>=1970 && g_date_year(date)<=2037)
        hildon_date_button_set_date(HILDON_DATE_BUTTON(mycalendar->date_picker),g_date_year(date),g_date_month(date)-1,g_date_day(date));
    g_date_free(date);
}

int main(int argc, char *argv[])
{
    GtkWidget *window, *vbox, *hbox, *vbox1, *hbox1;

    gtk_init(&argc, &argv);

    Calendar *mycalendar = g_malloc(sizeof(Calendar));

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    gtk_container_set_border_width (GTK_CONTAINER(window), 20);

    gtk_window_set_title(GTK_WINDOW (window), "日历");

    g_signal_connect (G_OBJECT (window), "destroy",
                      G_CALLBACK (window_destroy), mycalendar);

    vbox = gtk_vbox_new(FALSE, 2);
    hbox = gtk_hbox_new(FALSE, 2);
    vbox1 = gtk_vbox_new(FALSE, 2);
    hbox1 = gtk_hbox_new(FALSE, 2);
    mycalendar->label_lunar = gtk_label_new ("");
    mycalendar->label_holiday = gtk_label_new ("");
    GtkWidget *label=gtk_label_new("一   二   三   四   五   六   日   ");

    GtkWidget *today_button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
    GtkWidget *next_button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
    GtkWidget *prev_button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
    gtk_button_set_label(GTK_BUTTON(today_button),"今天");
    gtk_button_set_label(GTK_BUTTON(prev_button),"<");
    gtk_button_set_label(GTK_BUTTON(next_button),">");
    gtk_box_pack_start(GTK_BOX(hbox1), prev_button, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox1), today_button, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox1), next_button, TRUE, TRUE, 0);
    g_signal_connect (G_OBJECT (today_button), "released", G_CALLBACK (today), mycalendar);
    g_signal_connect (G_OBJECT (prev_button), "released", G_CALLBACK (month), mycalendar);
    g_signal_connect (G_OBJECT (next_button), "released", G_CALLBACK (month), mycalendar);

    mycalendar->date_picker=hildon_date_button_new(HILDON_SIZE_AUTO,HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    mycalendar->calendar = hildon_calendar_new();
    hildon_calendar_set_display_options(HILDON_CALENDAR(mycalendar->calendar), HILDON_CALENDAR_WEEK_START_MONDAY);
    GdkColor color={32,12450,46510,65535};
    gtk_widget_modify_bg(mycalendar->calendar,GTK_STATE_NORMAL,&color);
    gtk_widget_set_size_request(mycalendar->calendar,gdk_screen_width()/2,-1);

    g_signal_connect (G_OBJECT (mycalendar->calendar), "day_selected",
                      G_CALLBACK (calendar_clicked), mycalendar);
    g_signal_connect (G_OBJECT (mycalendar->date_picker), "value-changed",
                      G_CALLBACK (date_button_clicked), mycalendar);

    gtk_box_pack_start(GTK_BOX(vbox1), mycalendar->date_picker, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox1), label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox1), mycalendar->calendar, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), mycalendar->label_lunar, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(hbox), vbox1, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(vbox), mycalendar->label_holiday, FALSE, FALSE, 0);

    gtk_container_add (GTK_CONTAINER (window), vbox);

    gtk_widget_show_all (window);

    calendar_clicked(mycalendar->calendar,mycalendar);

    gtk_main();

    return 0;
}
