
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <hildon-fmmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "file-chooser-dialog.h"
#include "file-details-dialog.h"
#include "file-selection.h"
#include "file-system-storage-dialog.h"
#include "file-system-model.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType hildon_file_chooser_dialog_get_type(void);
GType hildon_file_details_dialog_get_type(void);
GType hildon_file_selection_get_type(void);
GType hildon_file_system_model_get_type(void);
GType hildon_file_system_storage_dialog_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Hildon {  class FileChooserDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FileDetailsDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FileSelection_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FileSystemModel_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FileSystemStorageDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Hildon { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(hildon_file_chooser_dialog_get_type(), &Hildon::FileChooserDialog_Class::wrap_new);
  Glib::wrap_register(hildon_file_details_dialog_get_type(), &Hildon::FileDetailsDialog_Class::wrap_new);
  Glib::wrap_register(hildon_file_selection_get_type(), &Hildon::FileSelection_Class::wrap_new);
  Glib::wrap_register(hildon_file_system_model_get_type(), &Hildon::FileSystemModel_Class::wrap_new);
  Glib::wrap_register(hildon_file_system_storage_dialog_get_type(), &Hildon::FileSystemStorageDialog_Class::wrap_new);

  // Register the gtkmm gtypes:
  Hildon::FileChooserDialog::get_type();
  Hildon::FileDetailsDialog::get_type();
  Hildon::FileSelection::get_type();
  Hildon::FileSystemModel::get_type();
  Hildon::FileSystemStorageDialog::get_type();

} // wrap_init()

} //Hildon


